function k = kerunic(xg,h) 
% KERUNIC, evaluates canonical version of the UNIform KERnel
%     at a grid of x's, xg (matrix or vector),
%     for the bandwidth h
%     For use in NonParametric Regression MOVies

%    Copyright (c) J. S. Marron and D. Ruppert, 1997

del0 = (9 / 2)^(1/5) ;
          %  Canonical rescaling from Marron and Nolan (1989)
          %      Stat. and Prob. Letters, 7, 195-199.

k = kerunif(xg / del0, h) / del0 ;





