function caestpar = makecaep(h,hf,lfmag,p,n,sig, ...
                        xstr,tarstr,sigstr,kerstr,mtitstr,movoutstr) 
% MAKECAEP, MAKEs Cell Array with Estimation Parameters
%     For use in NonParametric Regression MOVies
%     this puts the input parameters into the cell array caestpar
%   Inputs: (in order)
%       h - bandwidth,   scalar or 3-vector (col)
%       hf - bandwidth factor for local fit snakes (col)
%       lfmag - scalar, horizontal magnification factor for local fit snakes
%       p - local polynomial degree,   scalar or 3-vector (col)
%       n - sample size,  scalar or 3-vector (col)
%       sig - average value of noise level sigma,  scalar or 3-vector
%       xstr - string with name of function for generating x's
%       tarstr - string or 3-string matrix,
%                with name of function for generating target curve m
%       sigstr - string or 3-string matrix,
%                with name of function for generating sigma's
%       kerstr - string or 3-string matrix,
%                with name of function for generating kernel
%       mtitstr - string matrix of titles
%       movoutstr - string with directory and filename 
%                for storing movies as .mpg files
%
%    Copyright (c) J. S. Marron, E. Smith 1999


%  Pack ESTimation PARameters into a Cell Array
%
caestpar{1} = h ;
caestpar{2} = hf ;
caestpar{3} = lfmag ;
caestpar{4} = p ;
caestpar{5} = n ;
caestpar{6} = sig ;
caestpar{7} = xstr ;
caestpar{8} = tarstr ;
caestpar{9} = sigstr ;
caestpar{10} = kerstr ;
caestpar{11} = mtitstr ;
caestpar{12} = movoutstr ;




