disp('Running MATLAB script file nprmov1.m') ;
%
%    Creates a menu of NonParametric Regression MOVies
%    Accessed by pushbuttons

mfh = figure(1) ;
delete(mfh) ;
          %  this deletes window, in case it already exists,
          %  to avoid resizing each time pogram is rerun
mfh = figure(1) ;
colordef(mfh,'none') ; 
          %  this gives good black background, and sets other colors
set(mfh,'Name','NPR Movie Examples Menu') ;
set(mfh,'Color',[0 0 0]) ;
vpos = get(mfh,'Position') ;
vpos(2) = vpos(2) - 80 ;
          %  move this menu down by 80 pixels
vpos(4) = vpos(4) + 80 ;
          %  add 80 vertical pixels to this window
set(mfh,'Position',vpos) ;


%  Set global variables
%
global M1 ;
          %  M1 - Main Figure Movie Matrix




%  Set common parameters
%
nf = 50 ;    %  default number of frames
nrep = -4 ;    %  default number of replays (- makes it loop back and forth)
          %  think about making this user interfaced
fps = 12 ;    %  frames per second, controls how fast movie plays
                %  in Matlab displays
nrif = 4 ;
          %  number of times to Repeat Individual Movie Frames
          %    (controls speed of .mpeg version)

movoutdir = '\Movies\LocPoly\' ;
         %  output string for movie mpeg file

colormat = [1.0, 1.0, 1.0 ;
            0.8, 0.8, 0.8 ;   
              0, 0.5, 1.0 ;         
              0, 0.8, 0.8 ;
            1.0,   0, 1.0 ;
            0.5, 1.0, 1.0
            1.0, 1.0,   0 ;
              0, 1.0,   0 ;
            1.0,   0,   0 ;
                          ] ;

          %  Color matrix, with rows:
          %    1 - bright white,  for text, etc.
          %    2 - gray, for underlying target curve
          %    3 - bright, light blue, for data
          %    4 - dim cyan for location of estimation
          %    5 - magenta for kernel
          %    6 - bright cyan for estimating curve
          %    7 - yellow for snake 1
          %    8 - green for snake 2
          %    9 - red for snake 3

movopt = 1 ;
%  Movie options, currently using same as Cornean
%
%  This is MATLAB "help" to use for choosing parameters:
%	MPGWRITE(M, map, 'filename', options) Encodes M in MPEG format
% 	using the specified colormap and writes the result to the
% 	specified file.  The options argument is an optional vector of
% 	8 or fewer options where each value has the following meaning:
% 	1. REPEAT:
% 		An integer number of times to repeat the movie
% 		(default is 1).
% 	2. P-SEARCH ALGORITHM:
% 		0 = logarithmic	(fastest, default value)
% 		1 = subsample
% 		2 = exhaustive	(better, but slow)
% 	3. B-SEARCH ALGORITHM:
% 		0 = simple	(fastest)
% 		1 = cross2	(slightly slower, default value)
% 		2 = exhaustive	(very slow)
% 	4. REFERENCE FRAME:
% 		0 = original	(faster, default)
% 		1 = decoded	(slower, but results in better quality)
% 	5. RANGE IN PIXELS:
% 		An integer search radius.  Default is 10.
% 	6. I-FRAME Q-SCALE:
% 		An integer between 1 and 31.  Default is 8.
% 	7. P-FRAME Q-SCALE:
% 		An integer between 1 and 31.  Default is 10.
% 	8. B-FRAME Q-SCALE:
% 		An integer between 1 and 31.  Default is 25.



%  Pack MAIN movie PARameters into a Cell Array
%
camainpar{1} = nf ;
camainpar{2} = nrep ;
camainpar{3} = fps ;
camainpar{4} = nrif ;
camainpar{5} = colormat ;
camainpar{6} = movopt ;



%  Set button parameters
%
nbrow = 8 ;
          %  number of button rows
bhsiz = 110 ;
          %  button's horizontal size
bhgap = 10 ;
          %  button's horizontal gap
bhtot = bhsiz + bhgap ;
          %  button's total horizontal size

bvsiz = 30 ;
          %  button's vertical size
bvgap = 15 ;
          %  button's vertical gap
bvtot = bvsiz + bvgap ;
          %  button's total vertical size



%  Set text / editable text parameters
%
ntet = 4 ;
          %  number of text / editable text fields
tethsiz = 150 ;
          %  text / editable text's horizontal size
tethgap = 20 ;
          %  text / editable text's horizontal gap
tethtot = tethsiz + tethgap ;
          %  text / editable text's total horizontal size

tetvsiz = 18 ;
          %  text / editable text's vertical size
tetvgap = 10 ;
          %  text / editable text's vertical gap
tetvtot = tetvsiz + tetvgap ;
          %  text / editable text's total vertical size



%  Set MPEG save order
%
vmorder = makevmorder(nf,nrif) ;





%  Set "Editable text", for user change of # frames, speed, # replays
%                                   and mpeg save directory
%



%  First do text box above for # frames
%
tstr0a = ['Enter # of frames'] ;
th0a = uicontrol(mfh, 'Style', 'text',...
                 'Pos', [tethgap, nbrow*bvtot+2*bvgap+(ntet-1)*tetvtot, ...
                                                  tethsiz, tetvsiz],...
                 'String', tstr0a,...
                 'BackGroundColor', [.3 1 .3],...
                 'ForeGroundColor', [0 0 0]);


%  Next do editable text box for # frames
%
callstret1 = ['nrstr = get(eth1,''String'') ;' ...
              'nf = str2num(nrstr) ;' ...
              'camainpar{1} = nf ;' ...
              'vmorder = makevmorder(nf,nrif) ;' ...
                                               ] ;
eth1 = uicontrol(mfh,'Style','Edit',...
              'Position',[tethtot, nbrow*bvtot+2*bvgap+(ntet-1)*tetvtot, ...
                                                   tethsiz/4, tetvsiz], ...
              'String',num2str(nf), ...
              'BackgroundColor', [1 1 1], ...
              'CallBack',callstret1) ;



%  Then do text box above for frames per second
%
tstr0b = ['Enter frames/sec'] ;
th0b = uicontrol(mfh, 'Style', 'text',...
                 'Pos', [tethgap, nbrow*bvtot+2*bvgap+(ntet-2)*tetvtot, ...
                                                   tethsiz, tetvsiz],...
                 'String', tstr0b,...
                 'BackGroundColor', [.3 1 .3],...
                 'ForeGroundColor', [0 0 0]);

%  Next do editable text box for frames per second
%
callstret2 = ['nrstr = get(eth2,''String'') ;' ...
              'fps = str2num(nrstr) ;' ...
              'camainpar{3} = fps ;' ...
                                               ] ;
eth2 = uicontrol(mfh,'Style','Edit',...
              'Position',[tethtot, nbrow*bvtot+2*bvgap+(ntet-2)*tetvtot, ...
                                                   tethsiz/4, tetvsiz], ...
              'String',num2str(fps), ...
              'BackgroundColor', [1 1 1], ...
              'CallBack',callstret2) ;




%  Then do text box above for # replays
%
tsrt0c = ['Enter # of replays'] ;
th0c = uicontrol(mfh, 'Style', 'text',...
                 'Pos', [tethgap, nbrow*bvtot+2*bvgap+(ntet-3)*tetvtot, ...
                                                   tethsiz, tetvsiz],...
                 'String', tsrt0c,...
                 'BackGroundColor', [.3 1 .3],...
                 'ForeGroundColor', [0 0 0]);


%  Next do editable text box for # replays
%
callstret3 = ['nrstr = get(eth3,''String'') ;' ...
              'nrep = str2num(nrstr) ;' ...
              'camainpar{2} = nrep ;' ...
                                               ] ;
eth3 = uicontrol(mfh,'Style','Edit',...
              'Position',[tethtot, nbrow*bvtot+2*bvgap+(ntet-3)*tetvtot, ...
                 tethsiz/4, tetvsiz], ...
              'String',num2str(nrep), ...
              'BackgroundColor', [1 1 1], ...
              'CallBack',callstret3) ;




%  Next do text box for saving mpeg files
%
tstr0d = ['Enter Directory for mpeg file'] ;
th0d = uicontrol(mfh, 'Style', 'text',...
                 'Pos', [tethgap, nbrow*bvtot+2*bvgap+(ntet-4)*tetvtot, ...
                                                   tethsiz, tetvsiz],...
                 'String', tstr0d,...
                 'BackGroundColor', [.3 1 .3],...
                 'ForeGroundColor', [0 0 0]);


%  Next do editable text box for saving mpeg files
%
callstret4 = ['movoutdir = get(eth4,''String'') ;'] ;
eth4 = uicontrol(mfh,'Style','Edit',...
              'Position',[tethtot, nbrow*bvtot+2*bvgap+(ntet-4)*tetvtot, ...
                                                   tethsiz, tetvsiz], ...
              'String',movoutdir, ...
              'BackgroundColor', [1 1 1], ...
              'CallBack',callstret4) ;





% Set up title for group 1
%
th1 = uicontrol(mfh, 'Style', 'text',...
	'Pos', [bhgap+0*bhtot, (nbrow-1)*bvtot+2*bvgap, bhsiz, bvsiz],...
	'String', '1 - Band - Blip --->',...
	'BackGroundColor', [.3 0 1],...
	'ForeGroundColor', [1 1 1]);





%  Set up push button 1a, different bandwidths, tarblip target,poly. deg = 1
%
vh1a = [.07; .2; .6] ;
vh1a = [.075; .15; .3] ;
vh1a = [.05; .15; .45] ;
vhf1a = [2; 2; 2] ;    %  h factors for local fit snakes
                      %  2 for Gaussian, 1 for Epan, Triwt
                      %  ???  for canonical
lfmag1a = 3 ;          %  local fit snake magnification factor
p1a = 1 ;
n1a = 50 ;
sig1a = .2 ;
mtitstr1a = str2mat('Bandwidth = .05','Bandwidth = .15','Bandwidth = .45') ;

callstr1a = ['movoutstr1a = [movoutdir ''NPRMovie1a.mpg''] ;' ...
             'caestpar = makecaep(vh1a,vhf1a,lfmag1a,p1a,n1a,sig1a,' ...
                        ' ''xeqs'', ''tarblip'', ''sighomo'',' ...
                        ' ''kergaus'', mtitstr1a, movoutstr1a) ;' ...
             'mainfig1(camainpar,caestpar) ;'] ;
pbh1a = uicontrol (mfh,...
	'Style', 'push',...
	'String', '1a - deg = 1',...
	'BackGroundColor', [0 0 0],...
	'ForeGroundColor', [1 0 0],...	
	'Pos', [bhgap+1*bhtot, (nbrow-1)*bvtot+2*bvgap, bhsiz, bvsiz],...
	'CallBack', ['figure(2) ;' ...
                     'set(gcf,''Name'',''Movie 1a: Bandwidths - blip, deg = 1'') ;' ...
                      callstr1a]);




%  Set up push button 1b, different bandwidths, tarblip target,poly deg = 3
%
vh1b = [.1; .3; .9] ;
vhf1b = [2; 2; 2] ;    %  h factors for local fit snakes
                      %  2 for Gaussian, 1 for Epan, Triwt
                      %  ???  for canonical
lfmag1b = 1 ;          %  local fit snake magnification factor
p1b = 3 ;
n1b = 50 ;
sig1b = .2 ;
movoutstr1b = [movoutdir 'NPRMovie1b.mpg'] ;
mtitstr1b = str2mat('Bandwidth = .1','Bandwidth = .3','Bandwidth = .9') ;

callstr1b = ['movoutstr1b = [movoutdir ''NPRMovie1b.mpg''] ;' ...
				 'caestpar = makecaep(vh1b,vhf1b,lfmag1b,p1b,n1b,sig1b,' ...
                        ' ''xeqs'', ''tarblip'', ''sighomo'',' ...
                        ' ''kergaus'', mtitstr1b, movoutstr1b) ;' ...
             'mainfig1(camainpar,caestpar) ;'] ;

   pbh1b = uicontrol (mfh,...
	'Style', 'push',...
	'String', '1b - deg = 3',...
	'BackGroundColor', [0 0 0],...
	'ForeGroundColor', [1 0 0],...	
	'Pos', [bhgap+2*bhtot, (nbrow-1)*bvtot+2*bvgap, bhsiz, bvsiz],...
	'CallBack', ['figure(2) ;' ...
                     'set(gcf,''Name'',''Movie 1b: Bandwidths - blip, deg = 3'') ;' ...
                      callstr1b]);





%  Set up push button 1c, different bandwidths, tarblip target, poly deg = 5
vh1c = [.13; .4; 1.2] ;
vhf1c = [2; 2; 2] ;    %  h factors for local fit snakes
                      %  2 for Gaussian, 1 for Epan, Triwt
                      %  ???  for canonical
lfmag1c = 1 ;          %  local fit snake magnification factor
p1c = 5 ;
n1c = 50 ;
sig1c = .2 ;
movoutstr1c = [movoutdir 'NPRMovie1c.mpg'] ;
mtitstr1c = str2mat('Bandwidth = .13','Bandwidth = .4','Bandwidth = 1.2') ;

callstr1c = ['movoutstr1c = [movoutdir ''NPRMovie1c.mpg''] ;' ...
				 'caestpar = makecaep(vh1c,vhf1c,lfmag1c,p1c,n1c,sig1c,' ...
                        ' ''xeqs'', ''tarblip'', ''sighomo'',' ...
                        ' ''kergaus'', mtitstr1c, movoutstr1c) ;' ...
             'mainfig1(camainpar,caestpar) ;'] ;

   pbh1c = uicontrol (mfh,...
	'Style', 'push',...
	'String', '1c - deg = 5',...
	'BackGroundColor', [0 0 0],...
	'ForeGroundColor', [1 0 0],...	
	'Pos', [bhgap+3*bhtot, (nbrow-1)*bvtot+2*bvgap, bhsiz, bvsiz],...
	'CallBack', ['figure(2) ;' ...
                     'set(gcf,''Name'',''Movie 1c: Bandwidths - blip, deg = 5'') ;' ...
                      callstr1c]);




% Set up title for group 2
%
th2 = uicontrol(mfh, 'Style', 'text',...
	'Pos', [bhgap+0*bhtot, (nbrow-2)*bvtot+2*bvgap, bhsiz, bvsiz],...
	'String', '2 - Band - PW --->',...
	'BackGroundColor', [.3 0 1],...
	'ForeGroundColor', [1 1 1]);





%  Set up push button 2a, different bandwidths, piecewise target, poly deg = 0
vh2a = [.03; .1; .3] ;
vhf2a = [3; 2; 2] ;    %  h factors for local fit snakes
                      %  3 to make very small bandwidth snake visible
                      %  2 for Gaussian, 1 for Epan, Triwt
                      %  ???  for canonical
lfmag2a = 3 ;          %  local fit snake magnification factor
p2a = 0 ;
n2a = 50 ;
sig2a = .2 ;
mtitstr2a = str2mat('Bandwidth = .03','Bandwidth = .1','Bandwidth = .3') ;

callstr2a = ['movoutstr2a = [movoutdir ''NPRMovie2a.mpg''] ;' ...
             'caestpar = makecaep(vh2a,vhf2a,lfmag2a,p2a,n2a,sig2a,' ...
                        ' ''xeqs'', ''tarpw'', ''sighomo'',' ...
                        ' ''kergaus'', mtitstr2a, movoutstr2a) ;' ...
             'mainfig1(camainpar,caestpar) ;'] ;
pbh2a = uicontrol (mfh,...
	'Style', 'push',...
	'String', '2a - deg = 0',...
	'BackGroundColor', [0 0 0],...
	'ForeGroundColor', [1 0 0],...	
	'Pos', [bhgap+1*bhtot, (nbrow-2)*bvtot+2*bvgap, bhsiz, bvsiz],...
	'CallBack', ['figure(2) ;' ...
                     'set(gcf,''Name'',''Movie 2a: Bandwidths - PW, deg = 0'') ;' ...
                      callstr2a]);




%  Set up push button 2b, different bandwidths, piecewise target, deg = 1
%
vh2b = [.03; .1; .3] ;
vhf2b = [3; 2; 2] ;    %  h factors for local fit snakes
                      %  3 to make very small bandwidth snake visible
                      %  2 for Gaussian, 1 for Epan, Triwt
                      %  ???  for canonical
lfmag2b = 1 ;          %  local fit snake magnification factor
p2b = 1 ;
n2b = 50 ;
sig2b = .2 ;
movoutstr2b = [movoutdir 'NPRMovie2b.mpg'] ;
mtitstr2b = str2mat('Bandwidth = .05','Bandwidth = .15','Bandwidth = .45') ;

callstr2b = ['movoutstr2b = [movoutdir ''NPRMovie2b.mpg''] ;' ...
				 'caestpar = makecaep(vh2b,vhf2b,lfmag2b,p2b,n2b,sig2b,' ...
                        ' ''xeqs'', ''tarpw'', ''sighomo'',' ...
                        ' ''kergaus'', mtitstr2b, movoutstr2b) ;' ...
             'mainfig1(camainpar,caestpar) ;'] ;

   pbh2b = uicontrol (mfh,...
	'Style', 'push',...
	'String', '2b - deg = 1',...
	'BackGroundColor', [0 0 0],...
	'ForeGroundColor', [1 0 0],...	
	'Pos', [bhgap+2*bhtot, (nbrow-2)*bvtot+2*bvgap, bhsiz, bvsiz],...
	'CallBack', ['figure(2) ;' ...
                     'set(gcf,''Name'',''Movie 2b: Bandwidths - PW, deg = 1'') ;' ...
                      callstr2b]);





%  Set up push button 2c, different bandwidths, piecewise target, deg = 3

%
vh2c = [.05; .15; .45] ;
vhf2c = [2; 2; 2] ;    %  h factors for local fit snakes
                      %  2 for Gaussian, 1 for Epan, Triwt
                      %  ???  for canonical
lfmag2c = 1 ;          %  local fit snake magnification factor
p2c = 3 ;
n2c = 50 ;
sig2c = .2 ;
movoutstr2c = [movoutdir 'NPRMovie2c.mpg'] ;
mtitstr2c = str2mat('Bandwidth = .05','Bandwidth = .15','Bandwidth = .45') ;

callstr2c = ['movoutstr2c = [movoutdir ''NPRMovie2c.mpg''] ;' ...
				 'caestpar = makecaep(vh2c,vhf2c,lfmag2c,p2c,n2c,sig2c,' ...
                        ' ''xeqs'', ''tarpw'', ''sighomo'',' ...
                        ' ''kergaus'', mtitstr2c, movoutstr2c) ;' ...
             'mainfig1(camainpar,caestpar) ;'] ;

   pbh2c = uicontrol (mfh,...
	'Style', 'push',...
	'String', '2c - deg = 3',...
	'BackGroundColor', [0 0 0],...
	'ForeGroundColor', [1 0 0],...	
	'Pos', [bhgap+3*bhtot, (nbrow-2)*bvtot+2*bvgap, bhsiz, bvsiz],...
	'CallBack', ['figure(2) ;' ...
                     'set(gcf,''Name'',''Movie 2c: Bandwidths - PW, deg = 3'') ;' ...
                      callstr2c]);

% Set up title for group 3
%
th3 = uicontrol(mfh, 'Style', 'text',...
	'Pos', [bhgap+0*bhtot, (nbrow-3)*bvtot+2*bvgap, bhsiz, bvsiz],...
	'String', '3 - Poly Deg Low--->',...
	'BackGroundColor', [.3 0 1],...
	'ForeGroundColor', [1 1 1]);




%  Set up push button 3a, different low poly degrees, h small
%
h3a = .09 ;
vhf3a = [2; 2; 2] ;    %  h factors for local fit snakes
                      %  2 for Gaussian, 1 for Epan, Triwt
                      %  ???  for canonical
lfmag3a = 3 ;          %  local fit snake magnification factor
vp3 = [0; 1; 2] ;
n3a = 100 ;
sig3a = .5 ;
movoutstr3a = [movoutdir 'NPRMovie3a.mpg'] ;
mtitstr3a = str2mat(['Poly deg = ' num2str(vp3(1))], ...
                  ['Poly deg = ' num2str(vp3(2))], ...
                  ['Poly deg = ' num2str(vp3(3))]) ;
callstr3a = ['movoutstr3a = [movoutdir ''NPRMovie3a.mpg''] ;' ...
   			'caestpar = makecaep(h3a,vhf3a,lfmag3a,vp3,n3a,sig3a,' ...
			   ' ''xeqs'', ''tarsin3'', ''sighomo'',' ...
             ' ''kergaus'', mtitstr3a, movoutstr3a) ;' ...
             'mainfig1(camainpar,caestpar) ;'] ;

pbh3a = uicontrol (mfh,...
	'Style', 'push',...
	'String', '3a - h small',...
	'BackGroundColor', [0 0 0],...
	'ForeGroundColor', [1 0 0],...	
	'Pos', [bhgap+1*bhtot, (nbrow-3)*bvtot+2*bvgap, bhsiz, bvsiz],...
	'CallBack', ['figure(2) ; clf ;' ...
                     'set(gcf,''Name'',''Movie 3a: Poly. Degree Low, h small'') ;' ...
                      callstr3a]);





%  Set up push button 3b, different low poly degrees, h moderate
%
h3b = .27 ;
vhf3b = [2; 2; 2] ;    %  h factors for local fit snakes
                      %  2 for Gaussian, 1 for Epan, Triwt
                      %  ???  for canonical
lfmag3b = 3 ;          %  local fit snake magnification factor
n3b = 100 ;
sig3b = .5 ;
movoutstr3b = [movoutdir 'NPRMovie3b.mpg'] ;
mtitstr3b = str2mat(['Poly deg = ' num2str(vp3(1))], ...
                  ['Poly deg = ' num2str(vp3(2))], ...
                  ['Poly deg = ' num2str(vp3(3))]) ;
callstr3b = ['movoutstr3b = [movoutdir ''NPRMovie3b.mpg''] ;' ...
				 'caestpar = makecaep(h3b,vhf3b,lfmag3b,vp3,n3b,sig3b,' ...
                        ' ''xeqs'', ''tarsin3'', ''sighomo'',' ...
                        ' ''kergaus'', mtitstr3b, movoutstr3b) ;' ...
             'mainfig1(camainpar,caestpar) ;'] ;


   pbh3b = uicontrol (mfh,...
	'Style', 'push',...
	'String', '3b - h moderate',...
	'BackGroundColor', [0 0 0],...
	'ForeGroundColor', [1 0 0],...	
	'Pos', [bhgap+2*bhtot, (nbrow-3)*bvtot+2*bvgap, bhsiz, bvsiz],...
	'CallBack', ['figure(2) ; clf ;' ...
                     'set(gcf,''Name'',''Movie 3b: Poly. Degree Low, h moderate'') ;' ...
                      callstr3b]);







%  Set up push button 3c, different low poly degrees, h large
%
h3c = .8 ;
vhf3c = [2; 2; 2] ;    %  h factors for local fit snakes
                      %  2 for Gaussian, 1 for Epan, Triwt
                      %  ???  for canonical
lfmag3c = 3 ;          %  local fit snake magnification factor
p3c = [1; 2; 3] ;
n3c = 100 ;
sig3c = .5 ;
movoutstr3c = [movoutdir 'NPRMovie3b.mpg'] ;
mtitstr3c = str2mat(['Poly deg = ' num2str(vp3(1))], ...
                  ['Poly deg = ' num2str(vp3(2))], ...
                  ['Poly deg = ' num2str(vp3(3))]) ;
callstr3c = ['movoutstr3c = [movoutdir ''NPRMovie3c.mpg''] ;' ...
				 'caestpar = makecaep(h3c,vhf3c,lfmag3c,vp3,n3c,sig3c,' ...
                        ' ''xeqs'', ''tarsin3'', ''sighomo'',' ...
                        ' ''kergaus'', mtitstr3c, movoutstr3c) ;' ...
             'mainfig1(camainpar,caestpar) ;'] ;


   pbh3c = uicontrol (mfh,...
	'Style', 'push',...
	'String', '3c - h large',...
	'BackGroundColor', [0 0 0],...
	'ForeGroundColor', [1 0 0],...	
	'Pos', [bhgap+3*bhtot, (nbrow-3)*bvtot+2*bvgap, bhsiz, bvsiz],...
	'CallBack', ['figure(2) ; clf ;' ...
                     'set(gcf,''Name'',''Movie 3c: Poly. Degree Low, h large'') ;' ...
                      callstr3c]);



% Set up title for group 4
%
th4 = uicontrol(mfh, 'Style', 'text',...
	'Pos', [bhgap+0*bhtot, (nbrow-4)*bvtot+2*bvgap, bhsiz, bvsiz],...
	'String', '4 - Poly Deg High--->',...
	'BackGroundColor', [.3 0 1],...
	'ForeGroundColor', [1 1 1]);




%  Set up push button 4a, different high poly degrees, h small
%
h4a = .2 ;
vhf4a = [2; 2; 2] ;    %  h factors for local fit snakes
                      %  2 for Gaussian, 1 for Epan, Triwt
                      %  ???  for canonical
lfmag4a = 3 ;          %  local fit snake magnification factor
vp4 = [2; 3; 4] ;
n4a = 100 ;
sig4a = .5 ;
movoutstr4a = [movoutdir 'NPRMovie4a.mpg'] ;
mtitstr4a = str2mat(['Poly deg = ' num2str(vp4(1))], ...
                  ['Poly deg = ' num2str(vp4(2))], ...
                  ['Poly deg = ' num2str(vp4(3))]) ;
callstr4a = ['movoutstr4a = [movoutdir ''NPRMovie4a.mpg''] ;' ...
   			'caestpar = makecaep(h4a,vhf4a,lfmag4a,vp4,n4a,sig4a,' ...
			   ' ''xeqs'', ''tarsin3'', ''sighomo'',' ...
             ' ''kergaus'', mtitstr4a, movoutstr4a) ;' ...
             'mainfig1(camainpar,caestpar) ;'] ;

pbh4a = uicontrol (mfh,...
	'Style', 'push',...
	'String', '4a - h small',...
	'BackGroundColor', [0 0 0],...
	'ForeGroundColor', [1 0 0],...	
	'Pos', [bhgap+1*bhtot, (nbrow-4)*bvtot+2*bvgap, bhsiz, bvsiz],...
	'CallBack', ['figure(2) ; clf ;' ...
                     'set(gcf,''Name'',''Movie 4a: Poly. Degree High, h small'') ;' ...
                      callstr4a]);





%  Set up push button 4b, different high poly degrees, h moderate
%
h4b = .4 ;
vhf4b = [2; 2; 2] ;    %  h factors for local fit snakes
                      %  2 for Gaussian, 1 for Epan, Triwt
                      %  ???  for canonical
lfmag4b = 3 ;          %  local fit snake magnification factor
n4b = 100 ;
sig4b = .5 ;
movoutstr4b = [movoutdir 'NPRMovie4b.mpg'] ;
mtitstr4b = str2mat(['Poly deg = ' num2str(vp4(1))], ...
                  ['Poly deg = ' num2str(vp4(2))], ...
                  ['Poly deg = ' num2str(vp4(3))]) ;
callstr4b = ['movoutstr4b = [movoutdir ''NPRMovie4b.mpg''] ;' ...
				 'caestpar = makecaep(h4b,vhf4b,lfmag4b,vp4,n4b,sig4b,' ...
                        ' ''xeqs'', ''tarsin3'', ''sighomo'',' ...
                        ' ''kergaus'', mtitstr4b, movoutstr4b) ;' ...
             'mainfig1(camainpar,caestpar) ;'] ;


   pbh4b = uicontrol (mfh,...
	'Style', 'push',...
	'String', '4b - h moderate',...
	'BackGroundColor', [0 0 0],...
	'ForeGroundColor', [1 0 0],...	
	'Pos', [bhgap+2*bhtot, (nbrow-4)*bvtot+2*bvgap, bhsiz, bvsiz],...
	'CallBack', ['figure(2) ; clf ;' ...
                     'set(gcf,''Name'',''Movie 4b: Poly. Degree High, h moderate'') ;' ...
                      callstr4b]);







%  Set up push button 4c, different high poly degrees, h large
%
h4c = .8 ;
vhf4c = [2; 2; 2] ;    %  h factors for local fit snakes
                      %  2 for Gaussian, 1 for Epan, Triwt
                      %  ???  for canonical
lfmag4c = 3 ;          %  local fit snake magnification factor
p4c = [1; 2; 3] ;
n4c = 100 ;
sig4c = .5 ;
movoutstr4c = [movoutdir 'NPRMovie4b.mpg'] ;
mtitstr4c = str2mat(['Poly deg = ' num2str(vp4(1))], ...
                  ['Poly deg = ' num2str(vp4(2))], ...
                  ['Poly deg = ' num2str(vp4(3))]) ;
callstr4c = ['movoutstr4c = [movoutdir ''NPRMovie4c.mpg''] ;' ...
				 'caestpar = makecaep(h4c,vhf4c,lfmag4c,vp4,n4c,sig4c,' ...
                        ' ''xeqs'', ''tarsin3'', ''sighomo'',' ...
                        ' ''kergaus'', mtitstr4c, movoutstr4c) ;' ...
             'mainfig1(camainpar,caestpar) ;'] ;


   pbh4c = uicontrol (mfh,...
	'Style', 'push',...
	'String', '4c - h large',...
	'BackGroundColor', [0 0 0],...
	'ForeGroundColor', [1 0 0],...	
	'Pos', [bhgap+3*bhtot, (nbrow-4)*bvtot+2*bvgap, bhsiz, bvsiz],...
	'CallBack', ['figure(2) ; clf ;' ...
                     'set(gcf,''Name'',''Movie 4c: Poly. Degree High, h large'') ;' ...
                      callstr4c]);

% Set up title for group 5
%
th5 = uicontrol(mfh, 'Style', 'text',...
	'Pos', [bhgap+0*bhtot, (nbrow-5)*bvtot+2*bvgap, bhsiz, bvsiz],...
	'String', '5 - Kernels --->',...
	'BackGroundColor', [.3 0 1],...
	'ForeGroundColor', [1 1 1]);




%  Set up push button 5a, ordinary scalings
%
vh5a = .4 ;
vhf5a = [1; 1; 2] ;    %  h factors for local fit snakes
                      %  2 for Gaussian, 1 for Epan, Triwt
                      %  ???  for canonical
lfmag5a = 3 ;          %  local fit snake magnification factor
p5a = 1 ;
n5a = 50 ;
sig5a = .6 ;
mkerstr5a = str2mat('kertrwt','kerunif','kergaus') ;
movoutstr5a = [movoutdir 'NPRMovie5a.mpg'] ;
mtitstr5a = str2mat('Tri Weight', 'Uniform', 'Gaussian') ;
callstr5a = ['movoutstr5a = [movoutdir ''NPRMovie5a.mpg''] ;' ...
				 'caestpar = makecaep(vh5a,vhf5a,lfmag5a,p5a,n5a,sig5a,' ...
                        ' ''xeqs'', ''tarblip'', ''sighomo'',' ...
                        ' mkerstr5a, mtitstr5a, movoutstr5a) ;' ...
             'mainfig1(camainpar,caestpar) ;'] ;

   pbh5a = uicontrol (mfh,...
	'Style', 'push',...
	'String', '5a - Ordinary',...
	'BackGroundColor', [0 0 0],...
	'ForeGroundColor', [1 0 0],...	
	'Pos', [bhgap+1*bhtot, (nbrow-5)*bvtot+2*bvgap, bhsiz, bvsiz],...
	'CallBack', ['figure(2) ; clf ;' ...
                     'set(gcf,''Name'',''Movie 5a: Kernels, Ordinary Scaling'') ;' ...
                      callstr5a]);






%  Set up push button 5b, canonical scalings
%
vh5b = vh5a / (9 / 2)^(1/5) ;
          %  adjust so same at uniform
vhf5b = [1; 1; 2] ;    %  h factors for local fit snakes
                      %  2 for Gaussian, 1 for Epan, Triwt
                      %  ???  for canonical
lfmag5b = 3 ;          %  local fit snake magnification factor
p5b = 1 ;
n5b = 50 ;
sig5b = .6 ;
          
mkerstr5b = str2mat('kertrwc','kerunic','kergauc') ;
movoutstr5b = [movoutdir 'NPRMovie5b.mpg'] ;
mtitstr5b = str2mat('Tri Weight', 'Uniform', 'Gaussian') ;
callstr5b = ['movoutstr5b = [movoutdir ''NPRMovie5b.mpg''] ;' ...
				 'caestpar = makecaep(vh5b,vhf5b,lfmag5b,p5b,n5b,sig5b,' ...
                        ' ''xeqs'', ''tarblip'', ''sighomo'',' ...
                        ' mkerstr5b, mtitstr5b, movoutstr5b) ;' ...
             'mainfig1(camainpar,caestpar) ;'] ;


   pbh5b = uicontrol (mfh,...
	'Style', 'push',...
	'String', '5b - Canonical',...
	'BackGroundColor', [0 0 0],...
	'ForeGroundColor', [1 0 0],...	
	'Pos', [bhgap+2*bhtot, (nbrow-5)*bvtot+2*bvgap, bhsiz, bvsiz],...
	'CallBack', ['figure(2) ; clf ;' ...
                     'set(gcf,''Name'',''Movie 5b: Kernels, Canonical Scaling'') ;' ...
                      callstr5b]);






% Set up title for group 6
%
th6 = uicontrol(mfh, 'Style', 'text',...
	'Pos', [bhgap+0*bhtot, (nbrow-6)*bvtot+2*bvgap, bhsiz, bvsiz],...
	'String', '6 - n & sigma --->',...
	'BackGroundColor', [.3 0 1],...
	'ForeGroundColor', [1 1 1]);




%  Set up push button 6a, different n's, sigma fixed
%
h6a = .2 ;
vhf6a = [2; 2; 2] ;    %  h factors for local fit snakes
                      %  2 for Gaussian, 1 for Epan, Triwt
                      %  ???  for canonical
lfmag6a = 3 ;          %  local fit snake magnification factor
p6a = 1 ;
vn6 = [25; 100; 400] ;
sig6a = .2 ;
movoutstr6a = [movoutdir 'NPRMovie6a.mpg'] ;
mtitstr6a = str2mat(['n = ' num2str(vn6(1)) ', \sigma = ' num2str(sig6a)], ...
                  ['n = ' num2str(vn6(2)) ', \sigma = ' num2str(sig6a)], ...
                  ['n = ' num2str(vn6(3)) ', \sigma = ' num2str(sig6a)]) ;
callstr6a = ['movoutstr6a = [movoutdir ''NPRMovie6a.mpg''] ;' ...
	                'caestpar = makecaep(h6a,vhf6a,lfmag6a,p6a,vn6,sig6a,' ...
                        ' ''xeqs'', ''tarblip'', ''sighomo'',' ...
                        ' ''kergaus'', mtitstr6a, movoutstr6a) ;' ...
             'mainfig1(camainpar,caestpar) ;'] ;


pbh6a = uicontrol (mfh,...
	'Style', 'push',...
	'String', '6a - diff''t n',...
	'BackGroundColor', [0 0 0],...
	'ForeGroundColor', [1 0 0],...	
	'Pos', [bhgap+1*bhtot, (nbrow-6)*bvtot+2*bvgap, bhsiz, bvsiz],...
	'CallBack', ['figure(2) ; clf ;' ...
                     'set(gcf,''Name'',''Movie 6a: n & sigma, diff''''t n'') ;' ...
                      callstr6a]);





%  Set up push button 6b, different sigma's, n fixed
%
h6b = .2 ;
vhf6b = [2; 2; 2] ;    %  h factors for local fit snakes
                      %  2 for Gaussian, 1 for Epan, Triwt
                      %  ???  for canonical
lfmag6b = 3 ;          %  local fit snake magnification factor
p6b = 1 ;

n6b = 100 ;
vsig6 = [.1; .2; .4] ;
movoutstr6b = [movoutdir 'NPRMovie6b.mpg'] ;
mtitstr6b = str2mat(['n = ' num2str(n6b) ', \sigma = ' num2str(vsig6(1))], ...
                  ['n = ' num2str(n6b) ', \sigma = ' num2str(vsig6(2))], ...
                  ['n = ' num2str(n6b) ', \sigma = ' num2str(vsig6(3))]) ;
callstr6b = ['movoutstr6b = [movoutdir ''NPRMovie6b.mpg''] ;' ...
				 'caestpar = makecaep(h6b,vhf6b,lfmag6b,p6b,n6b,vsig6,' ...
                        ' ''xeqs'', ''tarblip'', ''sighomo'',' ...
                        ' ''kergaus'', mtitstr6b, movoutstr6b) ;' ...
             'mainfig1(camainpar,caestpar) ;'] ;

pbh6b = uicontrol (mfh,...
	'Style', 'push',...
	'String', '6b - diff''t sig',...
	'BackGroundColor', [0 0 0],...
	'ForeGroundColor', [1 0 0],...	
	'Pos', [bhgap+2*bhtot, (nbrow-6)*bvtot+2*bvgap, bhsiz, bvsiz],...
	'CallBack', ['figure(2) ; clf ;' ...
                     'set(gcf,''Name'',''Movie 6b: n & sigma, diff''''t sig'') ;' ...
                      callstr6b]);







%  Set up push button 6c, different n's and sigma's, sigma2/n fixed
%
h6c = .2 ;
vhf6c = [2; 2; 2] ;    %  h factors for local fit snakes
                      %  2 for Gaussian, 1 for Epan, Triwt
                      %  ???  for canonical
lfmag6c = 3 ;          %  local fit snake magnification factor
p6c = 1 ;
movoutstr6c = [movoutdir 'NPRMovie6c.mpg'] ;
mtitstr6c = str2mat(['n = ' num2str(vn6(1)) ', \sigma = ' num2str(vsig6(1))], ...
                  ['n = ' num2str(vn6(2)) ', \sigma = ' num2str(vsig6(2))], ...
                  ['n = ' num2str(vn6(3)) ', \sigma = ' num2str(vsig6(3))]) ;
callstr6c = ['movoutstr6c = [movoutdir ''NPRMovie6c.mpg''] ;' ...
				 'caestpar = makecaep(h6c,vhf6c,lfmag6c,p6c,vn6,vsig6,' ...
                        ' ''xeqs'', ''tarblip'', ''sighomo'',' ...
                        ' ''kergaus'', mtitstr6c, movoutstr6c) ;' ...
             'mainfig1(camainpar,caestpar) ;'] ;

pbh6c = uicontrol (mfh,...
	'Style', 'push',...
	'String', '6c - sig2/n fixed',...
	'BackGroundColor', [0 0 0],...
	'ForeGroundColor', [1 0 0],...	
	'Pos', [bhgap+3*bhtot, (nbrow-6)*bvtot+2*bvgap, bhsiz, bvsiz],...
	'CallBack', ['figure(2) ; clf ;' ...
                     'set(gcf,''Name'',''Movie 6c: n & sigma, sigma2/n fixed'') ;' ...
                      callstr6c]);







% Set up title for group 7
%
th7 = uicontrol(mfh, 'Style', 'text',...
  'Pos', [bhgap+0*bhtot, (nbrow-7)*bvtot+2*bvgap, bhsiz, bvsiz],... 
  'String', '7 - X designs --->',...
  'BackGroundColor', [.3 0 1],...
  'ForeGroundColor', [1 1 1]);






%  Set up push button 7a, different Designs, p=2
%
vh7a = .3 ;
vhf7a = [2; 2; 2] ;    %  h factors for local fit snakes
                      %  2 for Gaussian, 1 for Epan, Triwt
                      %  ???  for canonical
lfmag7a = 5 ;          %  local fit snake magnification factor
p7a = 2 ;
n7a = 100 ;
%sig7a = .5 ;
sig7a = .1 ;
mxstr7a = str2mat('xdec','xuni','xinc') ;
movoutstr7a = [movoutdir 'NPRMovie7a.mpg'] ;
mtitstr7a = str2mat('Decreasing Design','Uniform Design','Increasing Design') ;
callstr7a = ['movoutstr7a = [movoutdir ''NPRMovie7a.mpg''] ;' ...
				 'caestpar = makecaep(vh7a,vhf7a,lfmag7a,p7a,n7a,sig7a,' ...
                        ' mxstr7a, ''tarsin2'', ''sighomo'',' ...
                        ' ''kergaus'', mtitstr7a, movoutstr7a) ;' ...
             'mainfig1(camainpar,caestpar) ;'] ;

   pbh7a = uicontrol (mfh,...
	'Style', 'push',...
	'String', '7a - Rand X, p=2',...
	'BackGroundColor', [0 0 0],...
	'ForeGroundColor', [1 0 0],...	
   'Pos', [bhgap+1*bhtot, (nbrow-7)*bvtot+2*bvgap, bhsiz, bvsiz],...
   'CallBack', ['figure(2) ; clf ;' ...
                     'set(gcf,''Name'',''Movie 7a: Random X Dists, p=2'') ;' ...
                      callstr7a]);





%  Set up push button 7b, different Designs, p=3
%
vh7b = .3 ;
vhf7b = [2; 2; 2] ;    %  h factors for local fit snakes
                      %  2 for Gaussian, 1 for Epan, Triwt
                      %  ???  for canonical
lfmag7b = 5 ;          %  local fit snake magnification factor
p7b = 3 ;
n7b = 100 ;
%sig7b = .5 ;
sig7b = .1 ;
mxstr7b = str2mat('xdec','xuni','xinc') ;
movoutstr7b = [movoutdir 'NPRMovie7b.mpg'] ;
mtitstr7b = str2mat('Decreasing Design','Uniform Design','Increasing Design') ;
callstr7b = ['movoutstr7b = [movoutdir ''NPRMovie7b.mpg''] ;' ...
				 'caestpar = makecaep(vh7b,vhf7b,lfmag7b,p7b,n7b,sig7b,' ...
                        ' mxstr7b, ''tarsin2'', ''sighomo'',' ...
                        ' ''kergaus'', mtitstr7b, movoutstr7b) ;' ...
             'mainfig1(camainpar,caestpar) ;'] ;

   pbh7b = uicontrol (mfh,...
	'Style', 'push',...
	'String', '7b - Rand X, p=3',...
	'BackGroundColor', [0 0 0],...
	'ForeGroundColor', [1 0 0],...	
   'Pos', [bhgap+2*bhtot, (nbrow-7)*bvtot+2*bvgap, bhsiz, bvsiz],...
   'CallBack', ['figure(2) ; clf ;' ...
                     'set(gcf,''Name'',''Movie 7b: Random X Dists, p=3'') ;' ...
                      callstr7b]);






%  Set up push button 7c, fixed vs. random
%
vh7c = .2 ;
vhf7c = [2; 2; 2] ;    %  h factors for local fit snakes
                      %  2 for Gaussian, 1 for Epan, Triwt
                      %  ???  for canonical
lfmag7c = 5 ;          %  local fit snake magnification factor
p7c = 1 ;
vn7c = [50; 50; 450] ;
vsig7c = [.2; .2; .6] ;
mxstr7c = str2mat('xuni','xeqs','xuni') ;
movoutstr7c = [movoutdir 'NPRMovie7c.mpg'] ;
mtitstr7c = str2mat('Unif, n small','Eq. Spaced','Unif, n large') ;
callstr7c = ['movoutstr7c = [movoutdir ''NPRMovie7c.mpg''] ;' ...
				 'caestpar = makecaep(vh7c,vhf7c,lfmag7c,p7c,vn7c,vsig7c,' ...
                        ' mxstr7c, ''tarblip'', ''sighomo'',' ...
                        ' ''kergaus'', mtitstr7c, movoutstr7c) ;' ...
             'mainfig1(camainpar,caestpar) ;'] ;

   pbh7c = uicontrol (mfh,...
	'Style', 'push',...
	'String', '7c - Fix. vs. Rand.',...
	'BackGroundColor', [0 0 0],...
	'ForeGroundColor', [1 0 0],...	
	'Pos', [bhgap+3*bhtot, (nbrow-7)*bvtot+2*bvgap, bhsiz, bvsiz],...
	'CallBack', ['figure(2) ; clf ;' ...
                     'set(gcf,''Name'',''Movie 7c: Fixed vs. Random'') ;' ...
                      callstr7c]);







% Set up title for group 8
%
th8 = uicontrol(mfh, 'Style', 'text',...
	'Pos', [bhgap+0*bhtot, (nbrow-8)*bvtot+2*bvgap, bhsiz, bvsiz],...
	'String', '8 - Scedast.--->',...
	'BackGroundColor', [.3 0 1],...
	'ForeGroundColor', [1 1 1]);





%  Set up push button 8a, monotone scedasticities
%
vh8a = .35 ;
vhf8a = [2; 2; 2] ;    %  h factors for local fit snakes
                      %  2 for Gaussian, 1 for Epan, Triwt
                      %  ???  for canonical
lfmag8a = 3 ;          %  local fit snake magnification factor
p8a = 3 ;
n8a = 100 ;
sig8a = .5 ;
msigstr8a = str2mat('sigheti','sighomo','sighetd') ;
movoutstr8a = [movoutdir 'NPRMovie8a.mpg'] ;
mtitstr8a = str2mat('Noise Increasing','Noise Constant','Noise Decreasing') ;
callstr8a = ['movoutstr8a = [movoutdir ''NPRMovie8a.mpg''] ;' ...
				 'caestpar = makecaep(vh8a,vhf8a,lfmag8a,p8a,n8a,sig8a,' ...
                        ' ''xeqs'', ''tarsin3'', msigstr8a,' ...
                        ' ''kergaus'', mtitstr8a, movoutstr8a) ;' ...
             'mainfig1(camainpar,caestpar) ;'] ;

   pbh8a = uicontrol (mfh,...
	'Style', 'push',...
	'String', '8a - Monotone',...
	'BackGroundColor', [0 0 0],...
	'ForeGroundColor', [1 0 0],...	
	'Pos', [bhgap+1*bhtot, (nbrow-8)*bvtot+2*bvgap, bhsiz, bvsiz],...   
   'CallBack', ['figure(2) ; clf ;' ...
                     'set(gcf,''Name'',''Movie 8a: Monotone Scedasticity'') ;' ...
                      callstr8a]);






