disp('Running MATLAB script file LogNorm2LRD1figA.m') ;
%
%    Makes a mouse and elephant style graphics
%
%    Copied from UNC2000FlowSum1.m
%    with parameters set to:
%        ipart =  3 - Mice and Elephants plot 1, full time window
%        ifile =  1 - "Off Peak",
%                        092400_0830_in_ip_flow_packets.txt
%
%    Reads data saved in the file:
%         UNC2000FlowSum1Off.mat
%        (in the directory MatlabData)



mfilepre = '\Research\NetworkData\MainLinkTrace\UNCLink2000\MatlabData\' ;

mfile = ['UNC2000FlowSum1Off.mat'] ;
maintitstr = 'UNC main link 2000' ;
intitstr = 'incoming' ;
peaktitstr = 'Off Peak' ;

mfilestr = [mfilepre mfile] ;



figh = figure(1) ;
clf ;



%  Load Matlab file
%
eval(['load ' mfilestr ' ;']) ;
    %  summarized data is in "msumm"



winfrac = 1 ;
pstr = 'LogNorm2LRD1figA' ;
num2show = 1000 ;


nconn = size(msumm,1) ;
    %  number of connections here


vtimestart = msumm(:,1) ;
vtimeend = msumm(:,2) ;

mintime = min(vtimestart) ;
vtimestart = vtimestart - mintime ;
vtimeend = vtimeend - mintime ;
    %  reset so start at time 0

totaltime = max(vtimeend) ;
timeleft = (0.5 - winfrac / 2) * totaltime ;
timeright = (0.5 + winfrac / 2) * totaltime ;
    %  boundaries of window to plot

flag = (timeleft < vtimeend) & (vtimestart < timeright) ;
    %  one where interval has overlap with window

numoverlap = sum(flag) ;
disp(['  have ' num2str(numoverlap) ' out of ' ...
                num2str(nconn)  ' connections overlapping with window']) ;

%  find indices of connections to actually plot
%
rand('seed',92387094) ;
vind = (1:nconn)' ;
vind = vind(flag) ;
    %  reduce to those that overlap
vind = vind(randperm(numoverlap)) ;
    %  randomly reorder
vind = vind(1:num2show) ;
    %  take only 1st num2show of them

vtimestart = vtimestart(vind) ;
vtimeend = vtimeend(vind) ;

disp(['  plotting ' num2str(num2show) ' randomly chosen connections']) ;


%  compute summaries for connections that are plotted
%
meantime = mean(vtimeend - vtimestart) ;
mediantime = median(vtimeend - vtimestart) ;
fracfullwin = sum((vtimestart < timeleft) & (timeright < vtimeend)) / num2show ;


%  grow mice, so they can all be seen
%
smallwidth = (timeright - timeleft) / 400 ;
    %  1 / 400 of x axis range of plot
flagmouse = (vtimeend - vtimestart) < smallwidth ;
    %  one where there is a mouse in this sense
vtimeend(flagmouse) = vtimestart(flagmouse) + smallwidth ;
    %  padd out to a line of this width


rht = ((1:num2show)' - 0.5) / num2show ;
rht = rht(randperm(num2show)) ;
    %  random height for display of connections

plot([vtimestart'; vtimeend'],[rht'; rht'],'k-') ;
%  title([num2str(num2show) ' out of ' num2str(numoverlap) ...
%             ', that overlap window of ' num2str(winfrac) ', ' peaktitstr ...
%             ' IP "Raw" Connections'],'FontSize',18) ;
%  title('Figure A','FontSize',12) ;
%  xlabel('time (sec)','FontSize',18) ;
  xlabel('time (sec)','FontSize',12) ;
%  ylabel('Random Height','FontSize',18) ;
  ylabel('Random Height','FontSize',12) ;
    axis([timeleft,timeright,0,1]) ;

%  hold on ;
%    tx = timeleft + 0.1 * (timeright - timeleft) ;
%
%    ty = 0 + 0.9 * 1 ;
%    tstr = ['Mean Conn. time = ' num2str(meantime)] ;
%    text(tx,ty,tstr,'FontSize',18) ;
%
%    ty = 0 + 0.8 * 1 ;
%    tstr = ['Median Conn. time = ' num2str(mediantime)] ;
%    text(tx,ty,tstr,'FontSize',18) ;
%
%    ty = 0 + 0.7 * 1 ;
%    tstr = ['Frac. Full Window = ' num2str(fracfullwin)] ;
%    text(tx,ty,tstr,'FontSize',18) ;
%
%  hold off ;


  orient portrait ;
  set(gcf,'PaperSize',[6.0, 4.0]) ; 
  set(gcf,'PaperPosition',[0.25, 0.25, 5.5, 3.5]) ; 
print('-dpsc', [pstr '.ps']) ;





