disp('Running MATLAB script file LogNorm2LRD1figCD.m') ;
%
%    Makes log-log Q-Q plots for 1998 Response Size data
%
%    Copied from ResponseSize2.m
%    with parameters set to:
%    Fig C:    ipart = 11 - log(Pareto)  Q-Q on all default range
%                             (essentially ipart = 11, in ResponseSize1.m)
%    Fig D:    ipart = 31 - lognormal  Q-Q on all default range
%
%    Reads data saved in the file:
%         UNC2000FlowSum1Off.mat
%        (in the directory MatlabData)


ifig = 1 ;    %  1 - make Figure C
              %  2 - make Figure D


%  Read in Data
%
fid = fopen('\Research\NetworkData\ResponseSize\Respsize.txt','rt') ;
          %  'rt' is for "read only" and "text"
  fstr = '%f' ;
  [data,cnt] = fscanf(fid,fstr) ;
fclose('all') ;

%  size(data)
disp('  finished data read') ;
ndat = length(data) ;


fighand = figure(1) ;
clf ; 



if ifig == 1 ;    %  then make Figure C (old ipart = 11)

  vq = [.99, .999] ;
  titlestr = ['Q-Q Plot, Respsize, n = ' num2str(length(data),6) ...
                                ', q1 = ' num2str(vq(1)) ...
                                ', q2 = ' num2str(vq(2))] ;
  pstr = ['RespSize2ParetoQQall'] ;

%  paramstruct = struct('idist',12, ...
%                       'nsim',-100, ...
%                       'vqalign',vq, ...
%                       'ishowcross',1, ...
%                       'vshowq',[0.1; 0.5; 0.9], ...
%                       'iscreenwrite',1, ...
%                       'titlestr',titlestr, ...
%                       'titlefontsize',18, ...
%                       'ishowpar',1, ...
%                       'parfontsize',15, ...
%                       'labelfontsize',15, ...
%                       'savestr',pstr ...
%                                              ) ;
  paramstruct = struct('idist',12, ...
                       'nsim',-100, ...
                       'vqalign',vq, ...
                       'ishowcross',1, ...
                       'vshowq',[0.1; 0.5; 0.9], ...
                       'iscreenwrite',1, ...
                       'titlestr','', ...
                       'titlefontsize',12, ...
                       'ishowpar',1, ...
                       'parfontsize',12, ...
                       'labelfontsize',12, ...
                       'icolor',0 ...
                                              ) ;

  qqSM(data,paramstruct) ;


    pstr = 'LogNorm2LRD1figC' ;
    orient portrait ;
    set(gcf,'PaperSize',[6.0, 4.0]) ; 
    set(gcf,'PaperPosition',[0.25, 0.25, 5.5, 3.5]) ; 
  print('-dpsc', [pstr '.ps']) ;



elseif ifig == 2 ;    %  then make Figure D (old ipart = 31)


  vq = [.99, .999] ;
  titlestr = ['Q-Q Plot, Respsize, n = ' num2str(length(data),6) ...
                                ', q1 = ' num2str(vq(1)) ...
                                ', q2 = ' num2str(vq(2))] ;
  pstr = ['RespSize2logNormQQall'] ;

%  paramstruct = struct('idist',11, ...
%                       'nsim',-100, ...
%                       'vqalign',vq, ...
%                       'ishowcross',1, ...
%                       'vshowq',[0.1; 0.5; 0.9], ...
%                       'iscreenwrite',1, ...
%                       'titlestr',titlestr, ...
%                       'titlefontsize',18, ...
%                       'ishowpar',1, ...
%                       'parfontsize',15, ...
%                       'labelfontsize',15, ...
%                       'savestr',pstr ...
%                                              ) ;
  paramstruct = struct('idist',11, ...
                       'nsim',-100, ...
                       'vqalign',vq, ...
                       'ishowcross',1, ...
                       'vshowq',[0.1; 0.5; 0.9], ...
                       'iscreenwrite',1, ...
                       'titlestr','', ...
                       'titlefontsize',12, ...
                       'ishowpar',1, ...
                       'parfontsize',12, ...
                       'labelfontsize',12, ...
                       'icolor',0 ...
                                              ) ;
  qqSM(data,paramstruct) ;


    pstr = 'LogNorm2LRD1figD' ;
    orient portrait ;
    set(gcf,'PaperSize',[6.0, 4.0]) ; 
    set(gcf,'PaperPosition',[0.25, 0.25, 5.5, 3.5]) ; 
  print('-dpsc', [pstr '.ps']) ;



end ;



