disp('Running MATLAB script file MiceElephant1figC.m') ;
%
%    Makes a mouse and elephant style graphics
%    for the Mice and Elephant paper
%
%    Copied from UNC2001RespSiz2.m
%    with parameters set to:
%        ipart =  2 - full data read, and Mice and Elephants
%        itimeb = 11 ;    % Thursday, April 26, 13:00-17:00
%


itimeb = 11 ;
istepplot = 6 ;
    %  this gives same plot as UNC2001RS2MiceEleT11S6.ps
pstr = 'MiceElephant1figC' ;


figh = figure(1) ;
clf ;


%  Load earlier saved indexing, and summary info
%
load('\Research\NetworkData\ResponseSize\DataUNC2001\UNC2001RespSiz1DatSumm.mat') ;


%  Read in main data
%
filename = filenamecell{itimeb} ;
ncfilename = length(filename) ;
    %  number of characters in name
bigfilename = filename(1:(ncfilename-4)) ;
    %  cutoff last 4 characters
bigfilename = [bigfilename '.rsps.txt'] ;

tic ;
mresp = load(['\Research\NetworkData\ResponseSize\DataUNC2001\' bigfilename]) ;
loadtime = toc ;

n = size(mresp,1) ;


%  Main graphics
%
vstart = mresp(:,2) ;
    %  vector of start times
vstart = vstart - min(vstart) ;
    %  set so that smallest is 0

vend = vstart + mresp(:,3) ;
    %  vector of end times

mresp = [] ;
    %  to save space


%  set up graphic preliminaries
%
newfrac = 1/4 ;
nplot = 5000 ;
ntotal = length(vstart) ;
rand('state',1923475987435) ;


%  make first page, over full range of data
%
left = 0 ;
right = 4 * 60 * 60 ;
bottom = 0 ;
top = 1 ;
vind = randperm(n)' ;
    %  random re-ordering of indices
%vind = vind(1:nplot) ;
%    %  random indices for plotting
randht = rand(nplot,1) ;
    %  random height for y-coordinate

%plot([vstart(vind)'; vend(vind)'], ...
%                [randht'; randht'],'k-') ;
%  axis([left,right,bottom,top]) ;
%  title(['Mice & Elephants Plot, ' ...
%              daystrcell{itimeb} ', ' ...
%              timestrcell{itimeb} ', over 4 hours = ' ...
%              num2str(right - left) ' sec'],'FontSize',18) ;
%  xlabel('time (sec)','FontSize',18) ;
%  ylabel('Random Height','FontSize',18) ;
%    tx = left + 0.2 * (right - left) ;
%    ty = bottom + 0.9 * (top - bottom) ;
%  text(tx,ty,['Random sample of ' num2str(nplot)],'FontSize',18) ;
%    ty = bottom + 0.8 * (top - bottom) ;
%  text(tx,ty,['out of ' num2str(n) ' original responses'],'FontSize',18) ;

%hold on ;
  newleft = (right + left) / 2 - newfrac * (right - left) / 2 ;
  newright = (right + left) / 2 + newfrac * (right - left) / 2 ;
      %  new boundaries at center +- 1/2 of new fraction of all
%  plot([[newleft; newleft] , [newright; newright]], ...
%       [[bottom; top] , [bottom; top]],'g-') ;
%hold off ;
%
%pstr = ['UNC2001RS2MiceEleT' num2str(itimeb) 'S'] ;
%orient landscape ;
%print('-dpsc2',[pstr '1.ps']) ;


%  iterate through additional pages
%
nstep = 6 ;
    %  This is tuned for Thursday Afternoon
    %  If care about other time blocks, may want to tune this
for istep = 2:istepplot ;

  %  reduce data
  %
  keepflag = vstart <= newright ;
      %  ones where vstart <= right, i.e. not "off on right"
  keepflag = keepflag & (newleft <= vend) ;
      %  ones where also not "off on left"
  vstart = vstart(keepflag) ;
  vend = vend(keepflag) ;
  nkeep = length(vstart) ;
  numbracket = sum((vstart <= newleft) & (newright <= vend)) ;
      %  number that bracket full interval
  disp(['   kept ' num2str(nkeep) ' central responses']) ;

  if nkeep < nplot ;
    disp('!!!   Not enough responses left for full plot,') ;
    disp('!!!       terminating execution') ;
    break ;
  end ;


  %  make next plot
  %
  left = newleft ;
  right = newright ;
  bottom = 0 ;
  top = 1 ;
  vind = randperm(nkeep)' ;
      %  random re-ordering of indices
  vind = vind(1:nplot) ;
      %  random indices for plotting
  randht = rand(nplot,1) ;
      %  random height for y-coordinate


  newleft = (right + left) / 2 - newfrac * (right - left) / 2 ;
  newright = (right + left) / 2 + newfrac * (right - left) / 2 ;
      %  new boundaries at center +- 1/2 of new fraction of all


  if istep == istepplot ;

    plot([vstart(vind)'; vend(vind)'], ...
                    [randht'; randht'],'k-') ;
      axis([left,right,bottom,top]) ;
      xlabel('time (sec)') ;
      ylabel('Random Height') ;
%      title(['Zoomed Mice & Elephants Plot, ' ...
%                  daystrcell{itimeb} ', ' ...
%                  timestrcell{itimeb}, ', over ' ...
%                  num2str(right - left) ' sec'],'FontSize',18) ;
%      xlabel('time (sec)','FontSize',18) ;
%      ylabel('Random Height','FontSize',18) ;
%      tx = left + 0.2 * (right - left) ;
%      ty = bottom + 0.9 * (top - bottom) ;
%    text(tx,ty,['Random sample of ' num2str(nplot)],'FontSize',18) ;
%      ty = bottom + 0.8 * (top - bottom) ;
%    text(tx,ty,['from ' num2str(nkeep) ' crossing this range'],'FontSize',18) ;
%      ty = bottom + 0.7 * (top - bottom) ;
%    text(tx,ty,['out of ' num2str(n) ' original responses'],'FontSize',18) ;
%      ty = bottom + 0.6 * (top - bottom) ;
%    text(tx,ty,['(' num2str(numbracket) ' of which cover this range)'],'FontSize',18) ;

%    hold on ;
%      if istep < nstep ;
%        plot([[newleft; newleft] , [newright; newright]], ...
%             [[bottom; top] , [bottom; top]], 'g-') ;
%      end ;
%    hold off ;

  end ;


%  pstr = ['UNC2001RS2MiceEleT' num2str(itimeb) 'S'] ;
%  orient landscape ;
%  print('-dpsc2',[pstr num2str(istep) '.ps']) ;


end ;




  orient portrait ;
  set(gcf,'PaperSize',[6.0, 4.0]) ; 
  set(gcf,'PaperPosition',[0.25, 0.25, 5.5, 3.5]) ; 
print('-dps', [pstr '.ps']) ;


beep ;




