disp('Running MATLAB script file MiceElephant1figD.m') ;
%
%    Makes a mouse and elephant style graphics
%    for the Mice and Elephant paper
%
%    Copied from UNC2001RespSiz2.m
%    with parameters set to:
%        ipart =  3 - full data read, largest Elephants
%        itimeb = 11 ;    % Thursday, April 26, 13:00-17:00
%


itimeb = 11 ;
    %  this gives same plot as UNC2001RS2EleT11p5000.ps
pstr = 'MiceElephant1figD' ;


figh = figure(1) ;
clf ;


%  Load earlier saved indexing, and summary info
%
load('\Research\NetworkData\ResponseSize\DataUNC2001\UNC2001RespSiz1DatSumm.mat') ;


%  Read in main data
%
filename = filenamecell{itimeb} ;
ncfilename = length(filename) ;
    %  number of characters in name
bigfilename = filename(1:(ncfilename-4)) ;
    %  cutoff last 4 characters
bigfilename = [bigfilename '.rsps.txt'] ;

tic ;
mresp = load(['\Research\NetworkData\ResponseSize\DataUNC2001\' bigfilename]) ;
loadtime = toc ;

n = size(mresp,1) ;


%  Main graphics
%
vstart = mresp(:,2) ;
    %  vector of start times
vstart = vstart - min(vstart) ;
    %  set so that smallest is 0

vend = vstart + mresp(:,3) ;
    %  vector of start times

[temp,sortind] = sort(mresp(:,3)) ;
vind = (1:n)' ;
vind = vind(sortind) ;
    %  indices of data, sorted in increasing duration order

sortind = [] ;
mresp = [] ;
    %  to save space


%  set up graphic preliminaries
%
%figure(1) ;
%clf ;
vnplot = [5000] ;
%vnplot = [5000, 2000, 1000, 500, 200, 100] ;
maxnplot = max(vnplot) ;
ntotal = length(vstart) ;
rand('state',750937457093) ;


%  make main plots
%
left = 0 ;
right = 4 * 60 * 60 ;
bottom = 0 ;
top = 1 ;
randht = rand(maxnplot,1) ;
    %  random height for y-coordinate
randht = 1 - randht ;
    %  this simple transformation makes letters 
    %  appear more clearly for this seed

for nplot = vnplot ;

  vindplot = vind(n-nplot+1:n) ;
  randhtplot = randht(maxnplot-nplot+1:maxnplot) ;

  plot([vstart(vindplot)'; vend(vindplot)'], ...
                  [randhtplot'; randhtplot'],'k-') ;
    axis([left,right,bottom,top]) ;
    xlabel('time (sec)') ;
    ylabel('Random Height') ;
%    title(['Mice & Elephants Plot, ' ...
%                daystrcell{itimeb} ', ' ...
%                timestrcell{itimeb} ', over 4 hours = ' ...
%                num2str(right - left) ' sec'],'FontSize',18) ;
%    xlabel('time (sec)','FontSize',18) ;
%    ylabel('Random Height','FontSize',18) ;
%      tx = left + 0.2 * (right - left) ;
%      ty = bottom + 0.8 * (top - bottom) ;
%    text(tx,ty,['Largest ' num2str(nplot) ' of ' ...
%                   num2str(n) ' responses'],'FontSize',18) ;
%
%  hold on ;
%    newleft = (right + left) / 2 - newfrac * (right - left) / 2 ;
%    newright = (right + left) / 2 + newfrac * (right - left) / 2 ;
%        %  new boundaries at center +- 1/2 of new fraction of all
%    plot([[newleft; newleft] , [newright; newright]], ...
%         [[bottom; top] , [bottom; top]],'g-') ;
%  hold off ;

%  pstr = ['UNC2001RS2EleT' num2str(itimeb) ...
%                 'p' num2str(nplot)] ;
%  orient landscape ;
%  print('-dpsc2',[pstr '.ps']) ;

end ;





  orient portrait ;
  set(gcf,'PaperSize',[6.0, 4.0]) ; 
  set(gcf,'PaperPosition',[0.25, 0.25, 5.5, 3.5]) ; 
print('-dps', [pstr '.ps']) ;


beep ;




