disp('Running MATLAB script file StartTimeSiZer1fig1.m') ;
%
%    Makes a plot of just the start times for the
%    mouse and elephant style graphics
%
%    Copied from UNC2000FlowSum1.m
%    with parameters set to:
%        ipart =  4 - Mice and Elephants plot 2, 80% time window
%        ifile =  1 - "Off Peak",
%                        092400_0830_in_ip_flow_packets.txt
%
%    Reads data saved in the file:
%         UNC2000FlowSum1Off.mat
%        (in the directory MatlabData)

iout = 3 ;     %  1 - Figure for paper
               %  2 - "Big" version for talks
               %  3 - "Dark" version, for better .pdf files


mfilepre = '\Research\NetworkData\MainLinkTrace\UNCLink2000\MatlabData\' ;

mfile = ['UNC2000FlowSum1Off.mat'] ;
maintitstr = 'UNC main link 2000' ;
intitstr = 'incoming' ;
peaktitstr = 'Off Peak' ;

mfilestr = [mfilepre mfile] ;



figh = figure(1) ;
clf ;



%  Load Matlab file
%
eval(['load ' mfilestr ' ;']) ;
    %  summarized data is in "msumm"



pstr = 'StartTimeSiZer1fig1' ;



%  truncate data, as in ipart = 31, of UNC2000FlowSum1.m
%
startfrac = 0.2 ;
nconnoa = size(msumm,1) ;
    %  number of connections overall

vtimestart = msumm(:,1) ;
mintime = min(vtimestart) ;
maxtime = max(vtimestart) ;

vtimestart = vtimestart - mintime ;
totaltime = maxtime - mintime ;

timeleft = startfrac * totaltime ;
    %  boundary of window "after startup"

flag = timeleft < vtimestart ;
    %  one where connection starts after timeleft

nconn = sum(flag) ;
disp(['  have ' num2str(nconn) ' out of ' ...
                num2str(nconnoa)  ' connections starting after timeleft']) ;

vtimestart = vtimestart(flag) ;


num2show = 2000 ;


%  find indices of connections to actually plot
%
rand('seed',92387094) ;
vind = (1:nconn)' ;
vind = vind(randperm(nconn)) ;
    %  randomly reorder
vind = vind(1:num2show) ;
    %  take only 1st num2show of them

vtimestart = vtimestart(vind) ;

disp(['  plotting ' num2str(num2show) ' randomly chosen connections']) ;



rht = ((1:num2show)' - 0.5) / num2show ;
rht = rht(randperm(num2show)) ;
    %  random height for display of connections


  left = min(vtimestart) ;
  right = max(vtimestart) ;
if  iout == 1  |  iout == 2  ;
  plot(vtimestart,rht,'k.') ;
elseif iout == 3 ;
  plot(vtimestart,rht,'ko','MarkerSize',1,'LineWidth',2) ;
end ;
  xlh = xlabel('time (sec)','FontSize',12) ;
  ylh = ylabel('Random Height','FontSize',12) ;
  axis([left,right,0,1]) ;


if iout == 1 ;

    orient portrait ;
    set(gcf,'PaperSize',[6.0, 4.0]) ; 
    set(gcf,'PaperPosition',[0.25, 0.25, 5.5, 3.5]) ; 
  print('-dpsc', [pstr '.ps']) ;

elseif iout == 2 ;

  title('Start Times of IP Flows (2000 randomly chosen)', ...
                  'FontSize',18) ;
  set(xlh,'FontSize',18) ;
  set(ylh,'FontSize',18) ;

    orient landscape ;
  print('-dpsc', [pstr 'big.ps']) ;

elseif iout == 3 ;

    orient portrait ;
    set(gcf,'PaperSize',[6.0, 4.0]) ; 
    set(gcf,'PaperPosition',[0.25, 0.25, 5.5, 3.5]) ; 
  print('-dpsc', [pstr 'dark.ps']) ;

end ;




