disp('Running MATLAB script file StartTimeSiZer1fig3.m') ;
%
%    Makes Figure 3 for the Start Time SiZer paper
%
%    Copied from UNC2000FlowSim1.m
%
%    This does simulations, to allow deeper understanding of
%    results from UNC2000FlowSum1.m

%  uses old ipart = 1 ;   
               %  1 - SiZer analysis of process built from exponential
               %          waiting times, from file UNC2000FlowSum1StartExpQQOffs20.ps
               %          from ipart = 32, ifile = 1, of UNC2000FlowSum1.m



iout = 2 ;     %  1 - Figure for paper
               %  2 - movie version for talks



pstr = 'StartTimeSiZer1fig3' ;



figh = figure(1) ;
clf ;


%  generate data
%
n = 111822 ;
sigma = 0.015738 ;
    %  from UNC2000FlowSum1StartExpQQOffs20.ps

rand('seed',48274323) ;
vintarr = sigma * (-log(1 - rand(n,1))) ;
    %  generate Exponentials

vdata = cumsum(vintarr) ;

savestr = 'UNC2000FlowSimExpIntArr' ;
titstr = [' Exponential(' num2str(sigma) ') waiting times'] ;



%  do SiZer analysis
%
if iout == 1 ;

  paramstruct = struct('imovie',0,...
                       'hhighlight',0,...
                       'famoltitle',['Intensity Estimates'],...
                       'sizertitle',['SiZer analysis'],...
                       'titlefontsize',12,...
                       'xlabelstr','time (sec)',...
                       'ylabelstr','intensity',...
                       'labelfontsize',12,...
                       'ibdryadj',1,...
                       'iscreenwrite',1) ;

  sizerSM(vdata,paramstruct) ;



    orient portrait ;
    set(gcf,'PaperSize',[6.0, 8.0]) ; 
    set(gcf,'PaperPosition',[0.25, 0.25, 5.5, 7.5]) ; 
  print('-dpsc', [pstr '.ps']) ;


elseif iout == 2 ;

  paramstruct = struct('imovie',1,...
                       'fhmin',10^(0.5),...
                       'fhmax',10^(2.5),...
                       'shmin',10^(0.5),...
                       'shmax',10^(2.5),...
                       'famoltitle',['Homogenous Poisson Intensity Estimates'],...
                       'sizertitle',['SiZer analysis'],...
                       'titlefontsize',12,...
                       'xlabelstr','time (sec)',...
                       'ylabelstr','intensity',...
                       'labelfontsize',12,...
                       'ibdryadj',1,...
                       'savestr',pstr,...
                       'iscreenwrite',1) ;

  sizerSM(vdata,paramstruct) ;


end ;

