disp('Running MATLAB script file StartTimeSiZer1fig6.m') ;
%
%    Makes Figure 6 for the Start Time SiZer paper
%
%    Copied from UNC2000FlowSim1.m
%
%    This does simulations, to allow deeper understanding of
%    results from UNC2000FlowSum1.m

%  uses old ipart = 5 ;   
               %  5 - SiZer analysis of process built from Weibull, Toy 3
               %          alpha = 0.45,    sigma = 0.015 (same n)



iout = 2 ;     %  1 - Figure for paper
               %  2 - movie version for talks



pstr = 'StartTimeSiZer1fig6' ;



figh = figure(1) ;
clf ;


%  generate data
%
n = 111822 ;
alpha = 0.45 ;
sigma = 0.015738 * alpha / gamma(1 / alpha) ;
    %  Make Hannig's adjustment, for estimating sigma from Xbar
    %  based on expected value of the Weibull(alpha)
    %  i.e. method of moments estimate of sigma
    %  using Xbar from ipart = 1

rand('seed',74092734) ;
vintarr = sigma * (-log(1 - rand(n,1))).^(1 / alpha) ;
    %  generate Weibulls

vdata = cumsum(vintarr) ;

savestr = 'UNC2000FlowSimWeibToy3IntArr' ;
titstr = [' Weibull(' num2str(alpha) ',' num2str(sigma) ') waiting times'] ;



%  do SiZer analysis
%
if iout == 1 ;

  paramstruct = struct('imovie',0,...
                       'hhighlight',0,...
                       'famoltitle',['Intensity Estimates'],...
                       'sizertitle',['SiZer analysis'],...
                       'titlefontsize',12,...
                       'xlabelstr','time (sec)',...
                       'ylabelstr','intensity',...
                       'labelfontsize',12,...
                       'ibdryadj',1,...
                       'iscreenwrite',1) ;

  sizerSM(vdata,paramstruct) ;


    orient portrait ;
    set(gcf,'PaperSize',[6.0, 8.0]) ; 
    set(gcf,'PaperPosition',[0.25, 0.25, 5.5, 7.5]) ; 
  print('-dpsc', [pstr '.ps']) ;



elseif iout == 2 ;

  paramstruct = struct('imovie',1,...
                       'fhmin',10^(0.5),...
                       'fhmax',10^(2.5),...
                       'shmin',10^(0.5),...
                       'shmax',10^(2.5),...
                       'famoltitle',['Weibull(0.45) Renewal Intensity Estimates'],...
                       'sizertitle',['SiZer analysis'],...
                       'titlefontsize',12,...
                       'xlabelstr','time (sec)',...
                       'ylabelstr','intensity',...
                       'labelfontsize',12,...
                       'ibdryadj',1,...
                       'savestr',pstr,...
                       'iscreenwrite',1) ;

  sizerSM(vdata,paramstruct) ;


end ;

