disp('Running MATLAB script file StartTimeSiZer2fig2.m') ;
%
%    For making Figure 2 of the Start Time SiZer paper
%
%    Copied from StartTimeSiZer1fig2.m, which was
%
%    Copied from UNC2000FlowSum1.m 
%
%    For resaving and constructing Flow-wise summarizes
%    of Don Smith's UNC Main Link 2000 Flow data sets 
%        (in the directory RawData)
%         092400_0830_in_ip_flow_packets.txt
%         092600_1600_in_ip_flow_packets.txt
%    into a matlab matrix where each row is a flow, 
%         and columns are:
%         (1st time stamp)  (last time stamp)  (number of packets)
%                                    (total size)  (largest time gap)
%    that are saved in the files:
%         UNC2000FlowSum1Off.mat
%         UNC2000FlowSum1Peak.mat
%        (in the directory MatlabData)


%  this was:  ipart = 31 
               %  31 - SiZer analysis of flow start times (after 20%)


iout = 1 ;     %  1 - Figure for paper
               %  2 - movie version for talks



pstr = 'StartTimeSiZer2fig2' ;


%  This part was for ifile = 1  (off peak)
%
afilepre = '\Research\NetworkData\MainLinkTrace\UNCLink2000\RawData\' ;
mfilepre = '\Research\NetworkData\MainLinkTrace\UNCLink2000\MatlabData\' ;

afile = ['092400_0830_in_ip_flow_packets.txt'] ;
mfile = ['UNC2000FlowSum1Off.mat'] ;

afilestr = [afilepre afile] ;
mfilestr = [mfilepre mfile] ;



figh = figure(1) ;
clf ;



%  Load Matlab file
%
eval(['load ' mfilestr ' ;']) ;
  %  summarized data is in "msumm"




startfrac = 0.2 ;
nconnoa = size(msumm,1) ;
    %  number of connections overall

vtimestart = msumm(:,1) ;
mintime = min(vtimestart) ;
maxtime = max(vtimestart) ;

vtimestart = vtimestart - mintime ;
totaltime = maxtime - mintime ;

timeleft = startfrac * totaltime ;
    %  boundary of window "after startup"

flag = timeleft < vtimestart ;
    %  one where connection starts after timeleft

nconn = sum(flag) ;
disp(['  have ' num2str(nconn) ' out of ' ...
                num2str(nconnoa)  ' connections starting after timeleft']) ;

vtimestart = vtimestart(flag) ;


if iout == 1 ;

  paramstruct = struct('imovie',0,...
                       'hhighlight',0,...
                       'ibigdot',1,...
                       'famoltitle',['Intensity Estimates'],...
                       'sizertitle',['SiZer analysis'],...
                       'titlefontsize',12,...
                       'xlabelstr','time (sec)',...
                       'ylabelstr','intensity',...
                       'labelfontsize',12,...
                       'ibdryadj',1,...
                       'iscreenwrite',1) ;

  sizerSM(vtimestart,paramstruct) ;


  %  adjust axes of top plot
  %
  subplot(2,1,1) ;
  vax = axis ;
  axis([vax(1) vax(2) 0.0004 0.00073]) ;



    orient portrait ;
    set(gcf,'PaperSize',[6.0, 8.0]) ; 
    set(gcf,'PaperPosition',[0.25, 0.25, 5.5, 7.5]) ; 
  print('-dpsc', [pstr '.ps']) ;


elseif iout == 2 ;

  paramstruct = struct('imovie',1,...
                       'fhmin',10^(0.5),...
                       'fhmax',10^(2.5),...
                       'shmin',10^(0.5),...
                       'shmax',10^(2.5),...
                       'famoltitle',['IP Flow Start Intensity Estimates'],...
                       'sizertitle',['SiZer analysis'],...
                       'titlefontsize',12,...
                       'xlabelstr','time (sec)',...
                       'ylabelstr','intensity',...
                       'labelfontsize',12,...
                       'ibdryadj',1,...
                       'savestr',pstr,...
                       'iscreenwrite',1) ;

  sizerSM(vtimestart,paramstruct) ;


end ;



