disp('Running MATLAB script file StartTimeSiZer1fig4.m') ;
%
%    For making Figures 4a and 4b of the Start Time SiZer paper
%
%    Copied from UNC2000FlowSum1.m 
%
%    For resaving and constructing Flow-wise summarizes
%    of Don Smith's UNC Main Link 2000 Flow data sets 
%        (in the directory RawData)
%         092400_0830_in_ip_flow_packets.txt
%         092600_1600_in_ip_flow_packets.txt
%    into a matlab matrix where each row is a flow, 
%         and columns are:
%         (1st time stamp)  (last time stamp)  (number of packets)
%                                    (total size)  (largest time gap)
%    that are saved in the files:
%         UNC2000FlowSum1Off.mat
%         UNC2000FlowSum1Peak.mat
%        (in the directory MatlabData)

%  this was:  ipart = 32   (Figure 4a)
               %  32 - Exponential QQ analysis of interarrivals
               %                    of flow start times (after 20%)
%  and:  ipart = 34   (Figure 4b)
               %  34 - Est'd Weibull QQ analysis of interarrivals
               %                    of flow start times (after 20%)



iout = 2 ;     %  1 - Figure for paper
               %  2 - "Big" version for talks



pstr = 'StartTimeSiZer1fig4' ;

afilepre = '\Research\NetworkData\MainLinkTrace\UNCLink2000\RawData\' ;
mfilepre = '\Research\NetworkData\MainLinkTrace\UNCLink2000\MatlabData\' ;

%  This part was for ifile = 1  (off peak)
%
afile = ['092400_0830_in_ip_flow_packets.txt'] ;
mfile = ['UNC2000FlowSum1Off.mat'] ;

afilestr = [afilepre afile] ;
mfilestr = [mfilepre mfile] ;



figh = figure(1) ;
clf ;



%  Load Matlab file
%
eval(['load ' mfilestr ' ;']) ;
  %  summarized data is in "msumm"




%  make Figure 4a
%
startfrac = 0.2 ;
nconnoa = size(msumm,1) ;
    %  number of connections overall

vtimestart = msumm(:,1) ;
mintime = min(vtimestart) ;
maxtime = max(vtimestart) ;

vtimestart = vtimestart - mintime ;
totaltime = maxtime - mintime ;

timeleft = startfrac * totaltime ;
    %  boundary of window "after startup"

flag = timeleft < vtimestart ;
    %  one where connection starts after timeleft

nconn = sum(flag) ;
disp(['  have ' num2str(nconn) ' out of ' ...
                num2str(nconnoa)  ' connections starting after timeleft']) ;

vtimestart = vtimestart(flag) ;
    %  number of connections here

%  compute interarrival times
%
vtimestart = sort(vtimestart) ;
vintarr = vtimestart(2:nconn) - vtimestart(1:(nconn - 1)) ;

paramstruct = struct('idist',3, ...
                     'alpha',1, ...
                     'sigma',mean(vintarr), ...
                     'titlestr','',...
                     'vshowq',[0.5, 0.9, 0.99, 0.999], ...
                     'labelfontsize',12,...
                     'parfontsize',12,...
                     'ishowpar',1, ...
                     'iscreenwrite',1) ;

qqSM(vintarr,paramstruct) ;


if iout == 1 ;

    orient portrait ;
    set(gcf,'PaperSize',[6.0, 4.0]) ; 
    set(gcf,'PaperPosition',[0.25, 0.25, 5.5, 3.5]) ; 
  print('-dpsc', [pstr '.ps']) ;
  disp('    Finished File Save') ;


elseif iout == 2 ;

  title('Exponential Q-Q analysis of IP Flow Interarrivals', ...
                  'FontSize',18) ;
%  set(xlh,'FontSize',18) ;
%  set(ylh,'FontSize',18) ;

    orient landscape ;
  print('-dpsc', [pstr 'big.ps']) ;


end ;





%  make Figure 4b
%
vqalign = [0.9, 0.99] ;
paramstruct = struct('idist',3, ...
                     'vqalign',vqalign, ...
                     'titlestr','',...
                     'vshowq',[0.5, 0.9, 0.99, 0.999], ...
                     'labelfontsize',12,...
                     'parfontsize',12,...
                     'ishowpar',1, ...
                     'ishowcross',1, ...
                     'iscreenwrite',1) ;

qqSM(vintarr,paramstruct) ;



if iout == 1 ;

    orient portrait ;
    set(gcf,'PaperSize',[6.0, 4.0]) ; 
    set(gcf,'PaperPosition',[0.25, 0.25, 5.5, 3.5]) ; 
  print('-dpsc', [pstr 'b.ps']) ;
  disp('    Finished File Save') ;


elseif iout == 2 ;

  title('Weibull Q-Q analysis of IP Flow Interarrivals', ...
                  'FontSize',18) ;
%  set(xlh,'FontSize',18) ;
%  set(ylh,'FontSize',18) ;

    orient landscape ;
  print('-dpsc', [pstr 'bbig.ps']) ;


end ;

