disp('Running MATLAB script file StartTimeSiZer2fig5.m') ;
%
%    Makes Figure 5 for the Start Time SiZer paper
%
%    Copied from StartTimeSiZer1fig5.m, which was
%
%    Copied from UNC2000FlowSim1.m
%
%    This does simulations, to allow deeper understanding of
%    results from UNC2000FlowSum1.m

%  uses old ipart = 2 ;   
               %  2 - SiZer analysis of process built from Weibull
               %          waiting times, from
               %          from ipart = 34, ifile = 1, of UNC2000FlowSum1.m



iout = 1 ;     %  1 - Figure for paper
               %  2 - movie version for talks



pstr = 'StartTimeSiZer2fig5' ;



figh = figure(1) ;
clf ;


%  generate data
%
n = 111822 ;
alpha = 0.8986 ;
sigma = 0.01479 ;
    %  from UNC2000FlowSum1StartExpQQOffests20.ps

rand('seed',73207543) ;
vintarr = sigma * (-log(1 - rand(n,1))).^(1 / alpha) ;
    %  generate Weibulls

vdata = cumsum(vintarr) ;

savestr = 'UNC2000FlowSimWeibIntArr' ;
titstr = [' Weibull(' num2str(alpha) ',' num2str(sigma) ') waiting times'] ;


%  do SiZer analysis
%
if iout == 1 ;

  paramstruct = struct('imovie',0,...
                       'hhighlight',0,...
                       'ibigdot',1,...
                       'famoltitle',['Intensity Estimates'],...
                       'sizertitle',['SiZer analysis'],...
                       'titlefontsize',12,...
                       'xlabelstr','time (sec)',...
                       'ylabelstr','intensity',...
                       'labelfontsize',12,...
                       'ibdryadj',1,...
                       'iscreenwrite',1) ;

  sizerSM(vdata,paramstruct) ;


  %  adjust axes of top plot
  %
  subplot(2,1,1) ;
  vax = axis ;
  axis([vax(1) vax(2) 0.0004 0.00073]) ;



    orient portrait ;
    set(gcf,'PaperSize',[6.0, 8.0]) ; 
    set(gcf,'PaperPosition',[0.25, 0.25, 5.5, 7.5]) ; 
  print('-dpsc', [pstr '.ps']) ;



elseif iout == 2 ;

  paramstruct = struct('imovie',1,...
                       'fhmin',10^(0.5),...
                       'fhmax',10^(2.5),...
                       'shmin',10^(0.5),...
                       'shmax',10^(2.5),...
                       'famoltitle',['Weibull(0.9) Renewal Intensity Estimates'],...
                       'sizertitle',['SiZer analysis'],...
                       'titlefontsize',12,...
                       'xlabelstr','time (sec)',...
                       'ylabelstr','intensity',...
                       'labelfontsize',12,...
                       'ibdryadj',1,...
                       'savestr',pstr,...
                       'iscreenwrite',1) ;

  sizerSM(vdata,paramstruct) ;


end ;




