disp('Running MATLAB script file StartTimeSiZer2fig8.m') ;
%
%    Makes Figure 8 for the Start Time SiZer paper
%
%    Copied from StartTimeSiZer1fig8.m, which was
%
%    Copied from UNC2000FlowSim1.m
%
%    This does simulations, to allow deeper understanding of
%    results from UNC2000FlowSum1.m

%  uses old ipart = 14 ;   
               %  14 - SiZer analysis of clustered Poisson waiting times, 
               %          using 6000 initial Poisson starts
               %          and Poisson(16) cluster variables, 
               %          from triangular(0,20) distribution,
               %          (visual attempt at improving last)



iout = 1 ;     %  1 - Figure for paper
               %  2 - movie version for talks




pstr = 'StartTimeSiZer2fig8' ;



figh = figure(1) ;
clf ;


%  generate data
%
nstart = 6000 ;
sigma = 1800 / nstart ;

rand('seed',48274323) ;
vintarr = sigma * (-log(1 - rand(nstart,1))) ;
    %  generate Exponentials

vstart = cumsum(vintarr) ;
vdata = vstart ;

%  add clusters as appropriate
%
for i = 1:nstart ;
  clustnum = poissrnd(16) ;
      %  generate a Poisson(16) value
  if clustnum > 0 ;
    clustvar = rand(clustnum,1) ;
    clustvar = (1 - clustvar.^2) * 20 ;
        %  triangular density on (0,20)
    vdata = [vdata; vstart(i) + clustvar] ;
  end ;
end ;    %  of i loop through clusters

vdata = sort(vdata) ;
n = length(vdata) ;

savestr = 'UNC2000FlowSimClustPois14' ;
titstr = [' Poisson Cluster Process, 14'] ;



%  do SiZer analysis
%
if iout == 1 ;

  paramstruct = struct('imovie',0,...
                       'hhighlight',0,...
                       'ibigdot',1,...
                       'famoltitle',['Intensity Estimates'],...
                       'sizertitle',['SiZer analysis'],...
                       'titlefontsize',12,...
                       'xlabelstr','time (sec)',...
                       'ylabelstr','intensity',...
                       'labelfontsize',12,...
                       'ibdryadj',1,...
                       'iscreenwrite',1) ;

  sizerSM(vdata,paramstruct) ;


  %  adjust axes of top plot
  %
  subplot(2,1,1) ;
  vax = axis ;
  axis([vax(1) vax(2) 0.0004 0.00073]) ;


    orient portrait ;
    set(gcf,'PaperSize',[6.0, 8.0]) ; 
    set(gcf,'PaperPosition',[0.25, 0.25, 5.5, 7.5]) ; 
  print('-dpsc', [pstr '.ps']) ;



elseif iout == 2 ;

  paramstruct = struct('imovie',1,...
                       'fhmin',10^(0.5),...
                       'fhmax',10^(2.5),...
                       'shmin',10^(0.5),...
                       'shmax',10^(2.5),...
                       'famoltitle',['Cluster Poisson Intensity Estimates'],...
                       'sizertitle',['SiZer analysis'],...
                       'titlefontsize',12,...
                       'xlabelstr','time (sec)',...
                       'ylabelstr','intensity',...
                       'labelfontsize',12,...
                       'ibdryadj',1,...
                       'savestr',pstr,...
                       'iscreenwrite',1) ;

  sizerSM(vdata,paramstruct) ;


end ;


