disp('Running MATLAB script file VarHeavyTail2figD.m') ;

%    Makes Figure D for the Variable Heavy Tails paper

%    Copied from UNC2001RespSiz1.m
%    with parameters set to:
%        ipart = 41  -  Full Data Log-Log Complementary CDF
%        vitimeb = 1:21 ;    %  vector of indices of time blocks

%
%    For making analysis of Response Data, based on UNC traces
%    gathered in April 2001, by Don Smith and Co.
%    and filtered by Felix Hernandez Campos.
%
%    Because of the size of the data, they are summarized as:
%         Summary statistics:
%              rsp01power.xls
%              rsp01morestats.xls  (with trimmed down version in 
%                                           rsp01morestatsraw.xls
%                                   and just data saved in
%                                           rsp01morestatsraw.txt)
%         Quantiles of body of distribution:
%              responsesizequantiles.xls
%         Individual responses:
%              20010420_1300.raw
%                     to
%              20010429_800.raw
%                (21 time blocks)
%
%    For further details, see the files:
%         responsesizetailsnotes.txt
%         daydatekey.txt


vitimeb = 1:21 ;    %  vector of indices of time blocks
                    %  1 - Monday, April 23, 8:00-12:00
                    %  2 - Monday, April 23, 13:00-17:00
                    %  3 - Monday, April 23, 19:30-23:30
                    %  4 - Tuesday, April 24, 8:00-12:00
                    %  5 - Tuesday, April 24, 13:00-17:00
                    %  6 - Tuesday, April 24, 19:30-23:30
                    %  7 - Wednesday, April 25, 8:00-12:00
                    %  8 - Wednesday, April 25, 13:00-17:00
                    %  9 - Wednesday, April 25, 19:30-23:30
                    %  10 - Thursday, April 26, 8:00-12:00
                    %  11 - Thursday, April 26, 13:00-17:00
                    %  12 - Thursday, April 26, 19:30-23:30
                    %  13 - Friday, April 20, 8:00-12:00
                    %  14 - Friday, April 20, 13:00-17:00
                    %  15 - Friday, April 20, 19:30-23:30
                    %  16 - Saturday, April 21, 8:00-12:00
                    %  17 - Saturday, April 21, 13:00-17:00
                    %  18 - Saturday, April 21, 19:30-23:30
                    %  19 - Sunday, April 29, 8:00-12:00
                    %  20 - Sunday, April 29, 13:00-17:00
                    %  21 - Sunday, April 29, 19:30-23:30






figure(1) ;
clf ;


%  Load summary data (gives filenames, etc.)
%
%load('\Research\NetworkData\ResponseSize\DataUNC2001\UNC2001RespSiz1DatSumm.mat') ;
load('..\ResponseSize\DataUNC2001\UNC2001RespSiz1DatSumm.mat') ;


%  Load Quantiles
%
%fid = fopen('\Research\NetworkData\ResponseSize\DataUNC2001\responsesizequantilesRaw.txt','rt') ;
fid = fopen('..\ResponseSize\DataUNC2001\responsesizequantilesRaw.txt','rt') ;
        %  'rt' is for "read only" and "text"
fstr = '%f' ;
[mq,cnt] = fscanf(fid,fstr) ;
fclose('all') ;
mq = reshape(mq,21,1000)' ;
        %  use this for 1000x21 matrix, since reshape works column wise


cellcolstr = {'k' 'k' 'k' 'b' 'b' 'b' 'm' 'm' 'm' 'g' 'g' 'g' ...
              'r' 'r' 'r' 'y' 'y' 'y' 'c' 'c' 'c'} ;

%  loop through time blocks to lay down envelope of all
%
subplot(1,1,1) ;
  left = 1 ;
  right = 9 ;
  bottom = -7 ;
  top = 0.01 ;
plot([0; 0],[bottom,top]) ;
  axis([left, right, bottom, top]) ;
for itimeb = vitimeb ;    %  loop through time blocks

  disp(['       plotting for time block ' num2str(itimeb)]) ;

  %  first get part that appeared earlier
  %  (i.e. for given quantiles)
  %
  vq = mq(:,virowraw(itimeb)) ;
      %  unpack vector of quantiles

  n = vnumresp(itimeb) ;
      %  unpack full sample size

  nq = length(vq) ;
  vccdf = flipud((1/n) + (0:(nq-1))' / nq) ;


  %  second load large data values, and integrate
  %
  filename = filenamecell{itimeb} ;
%  mtailresp = load(['\Research\NetworkData\ResponseSize\DataUNC2001\' filename]) ;
  mtailresp = load(['..\ResponseSize\DataUNC2001\' filename]) ;
  vtailsize = mtailresp(:,1) ;
  ntail = length(vtailsize) ;

  vq = [vq; sort(vtailsize)] ;
  vccdf = [vccdf; flipud((1:ntail)' / n)] ;

  [vq, vindsort] = sort(vq) ;
  vccdf = vccdf(vindsort) ;


  %  lay down this one
  %
  hold on ;
    ph = plot(log10(vq),log10(vccdf),[cellcolstr{itimeb} '-']) ;
  hold off ;



end ;    %  of itimeb loop



%  do part common to all plots
%
hold on ;

%  tith = title('title string','FontSize',18) ;
%  xlabel('log_{10}(quantile)','FontSize',12) ;
  xlabel('log_{10}(x)','FontSize',12) ;
%  ylabel('log_{10}(1 - prob.)','FontSize',12) ;
  ylabel('log_{10}(P[X > x])','FontSize',12) ;

%    tx = left + 0.65 * (right - left) ;
%    ty = bottom + 0.9 * (top - bottom) ;
%  texth = text(tx,ty,'text string', ...
%                'FontSize',18,'Color','r') ;
%
%  vprobplot = [0.25, 0.5, 0.75, 0.9, 0.99, 0.999, 0.9999, 0.99999] ;
%  npp = length(vprobplot) ;
%  vpph = [] ;
%  vppth = [] ;
%  for probplot = vprobplot ;
%    ty = log10(1 - probplot) ;
%    tx = 5 ;
%    pph = plot(tx,ty,'k+','MarkerSize',10,'LineWidth',1) ;
%    tx = tx + 0.02 * (right - left) ;
%    ppth = text(tx,ty,[num2str(probplot) ' quantile'], ...
%                                 'FontSize',15) ;
%    vpph = [vpph; pph] ;
%    vppth = [vppth; ppth] ;
%  end ;

hold off ;




%      orient landscape ;
%    print('-dpsc2',['UNC2001RS1allCCDFfull' num2str(itimeb) '.ps']) ;






pstr = 'VarHeavyTail2figD' ;
  orient portrait ;
  set(gcf,'PaperSize',[6.0, 4.5]) ; 
  set(gcf,'PaperPosition',[0.25, 0.25, 5.5, 4.0]) ; 
print('-dpsc', [pstr '.ps']) ;




