disp('Running MATLAB script file VisChal1fig5.m') ;
%
%    Makes Figure 5 for the Visual Challenge paper,
%    the log-log scatterplot
%
%    Copied from UNC2001RespSiz2.m
%
%    with parameters set to:
%        ipart =  11 - full data read, and Mice and Elephants
%        itimeb = 19 - Sunday, April 29, 8:00-12:00
%


iout = 2 ;    %  1 - make figure for paper
              %  2 - make big picture for talk

itimeb = 19 ;
pstr = 'VisChal1fig5' ;


figh = figure(1) ;
clf ;


%  Load earlier saved indexing, and summary info
%
load('\Research\NetworkData\ResponseSize\DataUNC2001\UNC2001RespSiz1DatSumm.mat') ;


%  Read in main data
%
filename = filenamecell{itimeb} ;
ncfilename = length(filename) ;
    %  number of characters in name
bigfilename = filename(1:(ncfilename-4)) ;
    %  cutoff last 4 characters
bigfilename = [bigfilename '.rsps.txt'] ;

tic ;
mresp = load(['\Research\NetworkData\ResponseSize\DataUNC2001\' bigfilename]) ;
loadtime = toc ;

n = size(mresp,1) ;


%  Main graphics
%
disp(' ') ;
disp(['  Loaded ' num2str(n) ' by ' ...
                  num2str(size(mresp,2)) ' matrix in ' ...
                  num2str(loadtime) ' secs']) ;

flagnon0dur = mresp(:,3) > 0 ;
nnon0 = sum(flagnon0dur) ;

vx = mresp(flagnon0dur,1) ;
vy = mresp(flagnon0dur,3) ;
nplot = length(vx) ;
mresp = [] ;
    %  to save space


%  Set up preliminaries
%
timestr = [daystrcell{itimeb} ', ' timestrcell{itimeb}] ;
titlefontsize = 18 ;
textfontsize = 18 ;
labelfontsize = 18 ;
%mindat = min([vx; vy]) ;
%maxdat = max([vx; vy]) ;
%    %  overall extrema
%rangedat = maxdat - mindat ;
%rangelogdat = log10(maxdat) - log10(mindat) ;
minx = min(log10(vx)) ;
maxx = max(log10(vx)) ;
rangex = maxx - minx ;
minx = minx - 0.01 * rangex ;
maxx = maxx + 0.01 * rangex ;
miny = min(log10(vy)) ;
maxy = max(log10(vy)) ;
rangey = maxy - miny ;
miny = miny - 0.01 * rangey ;
maxy = maxy + 0.01 * rangey ;

xstr = 'Response Size (bytes)' ;
ystr = 'Response Duration (sec)' ;

plot(log10(vx),log10(vy),'k.') ;
%  axis([log10(mindat),log10(maxdat),log10(mindat),log10(maxdat)]) ;
  axis([minx,maxx,miny,maxy]) ;
  axis equal ;
  vax = axis ;
  minx = vax(1) ;
  maxx = vax(2) ;
  miny = vax(3) ;
  maxy = vax(4) ;
  rangex = maxx - minx ;
  rangey = maxy - miny ;
  if iout == 1 ;
    xlabel('log_{10}(Response Size)') ;
    ylabel('log_{10}(Response Duration)') ;
  elseif iout == 2 ;
    title('HTTP Responses (non-zero)','FontSize',titlefontsize) ;
    xlabel('log_{10}(Response Size)','FontSize',labelfontsize) ;
    ylabel('log_{10}(Response Time)','FontSize',labelfontsize) ;
    hold on ;
        tx = minx + 0.05 * rangex ;
        ty = miny + 0.9 * rangey ;
      text(tx,ty,['n = ' num2str(n) ' Total Responses'],'FontSize',textfontsize) ;
        tx = minx + 0.05 * rangex ;
        ty = miny + 0.8 * rangey ;
      text(tx,ty,['n = ' num2str(nnon0) ' non-0 Responses'],'FontSize',textfontsize) ;
        tx = minx + 0.05 * rangex ;
        ty = miny + 0.7 * rangey ;
      text(tx,ty,timestr,'FontSize',textfontsize) ;
    hold off ;
  end ;


%  pstr = ['UNC2001RS2logSPallT' num2str(itimeb)] ;
%  orient landscape ;
%  print('-dpsc2',[pstr '.ps']) ;



%  add 45 degree lines
%
hold on ;
  plot([minx; maxx],[(minx-2); (maxx-2)],'g--','LineWidth',2) ;
  plot([minx; maxx],[(-minx+7); (-maxx+7)],'g-','LineWidth',2) ;
hold off ;


if iout == 1 ;

    orient portrait ;
    set(gcf,'PaperSize',[6.0, 4.0]) ; 
    set(gcf,'PaperPosition',[0.25, 0.25, 5.5, 3.5]) ; 
  print('-dpsc2', '-r100', [pstr '.ps']) ;

elseif iout == 2 ;

    orient landscape ;
%  print('-dpsc2', [pstr 'big.ps']) ;
  print('-dpsc2', '-r110', [pstr 'big.ps']) ;

end ;


beep ;




