disp('Running MATLAB script file VisChal1fig6.m') ;
%
%    Makes Figure 6 for the Visual Challenge paper,
%    SiZer analysis of projections from the log-log scatterplot
%
%    Copied from UNC2001RespSiz2.m
%
%    with parameters set to:
%        ipart =  13 - full data read, SiZer on proj. on y = -x, smaller h, etc.
%        itimeb = 19 - Sunday, April 29, 8:00-12:00
%


iout = 1 ;    %  1 - make figure for paper
              %  2 - make big picture for talk

itimeb = 19 ;
pstr = 'VisChal1fig6' ;


figh = figure(1) ;
clf ;


%  Load earlier saved indexing, and summary info
%
load('\Research\NetworkData\ResponseSize\DataUNC2001\UNC2001RespSiz1DatSumm.mat') ;


%  Read in main data
%
filename = filenamecell{itimeb} ;
ncfilename = length(filename) ;
    %  number of characters in name
bigfilename = filename(1:(ncfilename-4)) ;
    %  cutoff last 4 characters
bigfilename = [bigfilename '.rsps.txt'] ;

tic ;
mresp = load(['\Research\NetworkData\ResponseSize\DataUNC2001\' bigfilename]) ;
loadtime = toc ;

n = size(mresp,1) ;


%  Main graphics
%
disp(' ') ;
disp(['  Loaded ' num2str(n) ' by ' ...
                  num2str(size(mresp,2)) ' matrix in ' ...
                  num2str(loadtime) ' secs']) ;

flagnon0dur = mresp(:,3) > 0 ;

vx = mresp(flagnon0dur,1) ;
vy = mresp(flagnon0dur,3) ;
nplot = length(vx) ;
mresp = [] ;
    %  to save space


projdat = (log10(vy) - log10(vx)) / sqrt(2) ;
projdat = -2 - projdat ;
    %  transform to be on "green line axes"


%    pstr = ['UNC2001RS2logSPprojSZsHallT' num2str(itimeb)] ;
%    timestr = [daystrcell{itimeb} ', ' timestrcell{itimeb}] ;
%    famtit = ['Projection of Response Size vs Duration, onto y = -x'] ;
%    siztit = ['for all non-0 durations, ' timestr] ;
%  paramstruct = struct('iout',1, ...
%                       'imovie',0, ...
%                       'nbin',1001, ...
%                       'minx',-5.5, ...
%                       'maxx',0.6, ...
%                       'hhighlight',0, ...
%                       'fhmin',10^(-3), ...
%                       'fhmax',10^(-0.5), ...
%                       'shmin',10^(-3), ...
%                       'shmax',10^(-0.5), ...
%                       'savestr',pstr, ...
%                       'famoltitle',famtit, ...
%                       'sizertitle',siztit, ...
%                       'titlefontsize',15, ...
%                       'iscreenwrite',1) ;

  paramstruct = struct('iout',1, ...
                       'imovie',0, ...
                       'nbin',1001, ...
                       'minx',-2.5, ...
                       'maxx',5, ...
                       'hhighlight',0, ...
                       'fhmin',10^(-3), ...
                       'fhmax',10^(-0.5), ...
                       'shmin',10^(-3), ...
                       'shmax',10^(-0.5), ...
                       'famoltitle','Jitter plot and kernel smooths', ...
                       'sizertitle','SiZer map', ...
                       'iscreenwrite',1) ;

  if iout == 2 ;
    paramstruct = setfield(paramstruct,'titlefontsize',18) ;
    paramstruct = setfield(paramstruct,'labelfontsize',15) ;
  end ;

sizerSM(projdat,paramstruct) ;




if iout == 1 ;

    orient portrait ;
    set(gcf,'PaperSize',[6.0, 7.0]) ; 
    set(gcf,'PaperPosition',[0.25, 0.25, 5.5, 6.5]) ; 
  print('-dpsc2', [pstr '.ps']) ;

elseif iout == 2 ;

    orient landscape ;
  print('-dpsc2', [pstr 'big.ps']) ;

end ;



beep ;




