/* =========================== START PROC BDFHB ======================== */
PROC BDFHB(BINCTS,H,KORD,ITYPE,ALPHA) ;
    /*  THIS DOES A BINNED CALCULATION OF A KERNEL DENSITY ESTIMATE   */
    /*  ASSUMED SUPPORTED ON [0,1]  */
    /*  IT ASSUMES BINS ARE EQUALLY SPACED WITH FIRST STARTING AT 0,  */
    /*  AND LAST ENDING AT 1  */
    /*  AND B IS ONE HALF BIN FROM RIGHT END  */
    /*  H IS BANDWIDTH AND KORD IS KERNEL ORDER  */
    /*  FOR ITYPE = 1, RETURNS UNADJUSTED PLUS MIRROR IMAGE ESTIMATORS  */
    /*  FOR ITYPE = 2, RETURNS UNADJUSTED PLUS MODIFIED RICE ESTIMATORS  */
    /*            ALPHA IS PARAMETER IN RICE'S METHOD, SUGGEST 2  */
    /*  FOR ITYPE = 3, RETURNS ALL THREE  */
    /*  REQUIRES NMFHB LOADABLE  */

  LOCAL NXGRID,BW,FBC,LBC,FBIGBC,LBIGBC,BIGBCTS,FHAT,OUT,FHATA,
           NXGO2,XGRID,RHO,KT,KTA,KTT,KTTA,DENOM,A,B ;


  NXGRID = ROWS(BINCTS) ;
  BW = 1 / NXGRID ;           /*  BINWIDTH  */
  FBC = BW / 2 ;              /*  FIRST BIN CENTER  */
  LBC = 1 - BW / 2 ;          /*  LAST BIN CENTER  */


  IF ITYPE == 1 OR ITYPE == 3 ;          /*  DO BOUNDARY REFLECTION  */

                /*  CALCULATE FHAT ON BIG GRID FOR REFLECTION  */
      FBIGBC = -1 + BW/2 ;       /*  FIRST BIN CENTER ON BIG GRID  */
      LBIGBC = 2 - BW/2 ;        /*  LAST BIN CENTER ON BIG GRID  */
      BIGBCTS = ZEROS(NXGRID,1)|BINCTS|ZEROS(NXGRID,1) ;
    FHAT = NMFHB(BIGBCTS,FBIGBC,LBIGBC,H,KORD) ;
    OUT = FHAT[(NXGRID+1):(2*NXGRID),.] ;      /*  UNADJUSTED VERSION  */

                /*  GET REFLECTED VALUE  */
    FHATA = REV(FHAT[1:NXGRID,.]) + FHAT[(NXGRID+1):(2*NXGRID),.] ;
    FHATA = FHATA + REV(FHAT[(2*NXGRID+1):(3*NXGRID),.]) ;
    FHAT = FHATA ;
    OUT = OUT~FHAT ;

  ENDIF ;


  IF ITYPE == 2 OR ITYPE == 3 ;     /*  RICE STYLE ADJUSMENT  */

    FHAT = NMFHB(BINCTS,FBC,LBC,H,KORD) ;

    IF ITYPE == 2 ;      /*  OUT NOT STARTED YET, SO INITIALIZE  */
      OUT = FHAT ;
    ENDIF ;              /*  ELSE OUT ALREADY STARTED  */

    FHATA = NMFHB(BINCTS,FBC,LBC,ALPHA*H,KORD) ;

      NXGO2 = CEIL(NXGRID/2) ;
      XGRID = SEQA(FBC,BW,NXGO2) ;
      RHO = XGRID / H ;

    KT = CDFN(RHO) ;
    KTA = CDFN(RHO ./ ALPHA) ;
    KTT = -PDFN(RHO) ;
    KTTA = -PDFN(RHO ./ ALPHA) ;

      DENOM = ALPHA .* KT .* KTTA - KTA .* KTT ;
    A = ALPHA .* KTTA ./ DENOM ;
    B = KTT ./ DENOM ;

    IF NXGO2 ==  NXGRID / 2 ;            /*  IF EVEN NUMBER OF BINS  */
      A = A|REV(A) ;
      B = B|REV(B) ;
    ELSE ;                               /*  IF ODD NUMBER OF BINS  */
      A = A|REV(A[1:NXGO2-1,.]) ;
      B = B|REV(B[1:NXGO2-1,.]) ;
    ENDIF ;

    FHAT = A .* FHAT  -  B .* FHATA ;
    OUT = OUT~FHAT ;

  ENDIF ;


  RETP(OUT) ;
ENDP ;
/* ============================ END PROC BDFHB ======================== */
