/* =========================== START PROC BDSPL ======================== */
PROC BDSPL(X,DEG,VPAR,BETA) ;
    /*  THIS EVALUATES THE SPLINE  */
    /*  FOR TRANSFORMATIONS  */
    /*  FOR DEG > 0, FITS A POLYNOMIAL OF DEGREE DEG TO CDF  */
    /*  FOR DEG = -1, ASSUMES VPAR = XI1|XI3, KNOT LOCATIONS FOR  */
    /*          A SPLINE THAT IS QUADRATIC AT ENDS, CUBIC IN MIDDLE  */
  LOCAL NOBS,XI1,XI2,XI3,V1,V2,V3,MX,I ;

  NOBS = ROWS(X) ;

  IF DEG == -1 ;         /*  FIT SPLINE WITH KNOTS AT XIi  */
    XI1 = VPAR[1,1] ;
    XI3 = VPAR[2,1] ;
    XI2 = (XI1 + XI3) / 2 ;

    V1 = (X - XI1) ;
    V1 = V1 .* (V1 .> 0) ;
    V2 = (X - XI2) ;
    V2 = V2 .* (V2 .> 0) ;
    V3 = (X - XI3) ;
    V3 = V3 .* (V3 .> 0) ;

    MX = ONES(NOBS,1) ;
    MX = MX~X ;
    MX = MX~(X^2) ;
    MX = MX~(V1^3 - V3^3) ;
    MX = MX~(V2^3 - V3^3) ;
  ELSEIF DEG > 0 ;             /*  FIT POLYNOMIAL  */
    MX = ONES(NOBS,1) ;
    MX = MX~X ;
    I = 2 ;
    DO WHILE I <= DEG ;
      MX = MX~(X^I) ;
      I = I + 1 ;
    ENDO ;
  ELSE ;
    "!!!!!!  INCORRECT PARAMETER SPECIFIED  !!!!!!" ;
  ENDIF ;

  RETP(MX * BETA) ;
ENDP ;
/* ============================ END PROC BDSPL ======================== */
