/* =========================== START PROC BDSPLD ======================== */
PROC BDSPLD(X,DEG,VPAR,BETA) ;
    /*  THIS EVALUATES THE DERIVATIVE OF THE SPLINE  */
    /*  FOR TRANSFORMATIONS  */
    /*  FOR DEG > 0, FITS A POLYNOMIAL OF DEGREE DEG TO CDF  */
    /*  FOR DEG = -1, ASSUMES VPAR = XI1|XI3, KNOT LOCATIONS FOR  */
    /*          A SPLINE THAT IS QUADRATIC AT ENDS, CUBIC IN MIDDLE  */
  LOCAL NOBS,XI1,XI2,XI3,V1,V2,V3,MX,I ;

  NOBS = ROWS(X) ;

  IF DEG == -1 ;         /*  FIT SPLINE WITH KNOTS AT XIi  */
    XI1 = VPAR[1,1] ;
    XI3 = VPAR[2,1] ;
    XI2 = (XI1 + XI3) / 2 ;

    V1 = (X - XI1) ;
    V1 = V1 .* (V1 .> 0) ;
    V2 = (X - XI2) ;
    V2 = V2 .* (V2 .> 0) ;
    V3 = (X - XI3) ;
    V3 = V3 .* (V3 .> 0) ;

    MX = ONES(NOBS,1) ;
    MX = MX~(2 * X) ;
    MX = MX~(3 * (V1^2 - V3^2)) ;
    MX = MX~(3 * (V2^2 - V3^2)) ;
  ELSEIF DEG > 0 ;             /*  FIT POLYNOMIAL  */
    MX = ONES(NOBS,1) ;
    I = 2 ;
    DO WHILE I <= DEG ;
      MX = MX~(I * X^(I-1)) ;
      I = I + 1 ;
    ENDO ;
  ELSE ;
    "!!!!!!  INCORRECT PARAMETER SPECIFIED  !!!!!!" ;
  ENDIF ;

  RETP(  MX * BETA[2:ROWS(BETA),.]  ) ;
ENDP ;
/* ============================ END PROC BDSPLD ======================== */
