/* =========================== START PROC BDSPLP ======================== */
PROC BDSPLP(XSORT,DEG,VPAR,WPAR) ;
    /*  THIS CALCULATES PARAMETERS FOR  */
    /*  THE SPLINE FOR TRANSFORMATIONS  */
    /*  FOR DEG > 0, FITS A POLYNOMIAL OF DEGREE DEG TO CDF  */
    /*  FOR DEG = -1, ASSUMES VPAR = XI1|XI3, KNOT LOCATIONS FOR  */
    /*          A SPLINE THAT IS QUADRATIC AT ENDS, CUBIC IN MIDDLE  */
    /*  WPAR ARE PARAMETERS FOR WEIGHTS,  */
    /*      WPAR = 0, IS UNWEIGHTED FITS  */
    /*      WPAR = 1|ALPHA,  IS WEIGHTED LEAST SQUARES, WITH WEIGHT ON  */
    /*               ONLY FIRST AND LAST ALPHA OF THE DATA  */
    /*  ASSUMES XSORTED IS SORTED DATA  */
  LOCAL NOBS,ALPHA,NSMALL,WT,XI1,XI2,XI3,V1,V2,V3,MX,I,EDF,BETA,VALUE ;

  NOBS = ROWS(XSORT) ;
  IF WPAR[1,1] == 0 ;
    WT = ONES(NOBS,1) ;
  ELSEIF WPAR[1,1] == 1 ;
    ALPHA = WPAR[2,1] ;
    NSMALL = FLOOR(ALPHA*NOBS) ;
    WT = ONES(NSMALL,1) ;
    WT = WT|ZEROS(NOBS - 2*NSMALL,1)|WT ;
  ENDIF ;

  IF DEG == -1 ;         /*  FIT SPLINE WITH KNOTS AT XIi  */
    XI1 = VPAR[1,1] ;
    XI3 = VPAR[2,1] ;
    XI2 = (XI1 + XI3) / 2 ;

    V1 = (XSORT - XI1) ;
    V1 = V1 .* (V1 .> 0) ;
    V2 = (XSORT - XI2) ;
    V2 = V2 .* (V2 .> 0) ;
    V3 = (XSORT - XI3) ;
    V3 = V3 .* (V3 .> 0) ;

    MX = ONES(NOBS,1) ;
    MX = MX~XSORT ;
    MX = MX~(XSORT^2) ;
    MX = MX~(V1^3 - V3^3) ;
    MX = MX~(V2^3 - V3^3) ;
  ELSEIF DEG > 0 ;             /*  FIT POLYNOMIAL  */
    MX = ONES(NOBS,1) ;
    MX = MX~XSORT ;
    I = 2 ;
    DO WHILE I <= DEG ;
      MX = MX~(XSORT^I) ;
      I = I + 1 ;
    ENDO ;
  ELSE ;
    "!!!!!!  INCORRECT PARAMETER SPECIFIED  !!!!!!" ;
  ENDIF ;

  EDF = SEQA(1,1,NOBS) / NOBS ;

  MX = WT .* MX ;
  BETA = INV(MX' * MX) * (MX' * EDF) ;

  VALUE = BDSPLD(XSORT,DEG,VPAR,BETA) ;
  IF MINC(VALUE) < 0 ;
    BETA = -1 ; ? ;
    "***********************************" ;
    "***                             ***" ;
    "***   CAREFUL, CAN'T USE THIS   ***" ;
    "***                             ***" ;
    "***********************************" ; ? ;
  ENDIF ;

  RETP(BETA) ;
ENDP ;
/* ============================ END PROC BDSPLP ======================== */
