/* =========================== START PROC BNCVM ======================== */
PROC BNCVM(TGRID,BINCTS) ;
   /*  BINNED CALCULATION OF THE CRAMER VON MISES STATISTIC  */
   /*     OF STEPHENS (1974) JASA   */
   /*  TGRID IS THE BIN CENTERS AFTER AN ATTEMPTED  */
   /*     TRANSFORMATION TO UNIFORMITY (PROBABLY NO LONGER EQUAL SPACED)   */
   /*     THESE MUST BE IN INCREASING ORDER    */
   /*  BINCTS IS FOR ORIGINAL BINNING, AS DONE BY BNLBD1.G     */

 LOCAL N,G,CC,CENT,CVM ;

 N = SUMC(BINCTS) ;
 G = ROWS(BINCTS) ;

 CC = CUMSUMC(BINCTS) / N ;    /*  CUMULATIVE BIN COUNTS, ENDPOINTS OF
                                    "REPRESENTATIVE SUBINTERVAL OF [0,1]  */

 CENT = ((0|CC[1:G-1]) + CC) / 2 ;
                           /*  CENTERS OF REPRESENTATIVE SUBINTERVALS  */

 CVM = SUMC( (TGRID - CENT)^2 ) ;

 CVM = (N / G) * CVM + 1 / (12 * N) ;      /*  PUTS ON STEPHEN'S SCALE  */

 RETP(CVM) ;
ENDP ;
/* ============================ END PROC BNCVM ======================== */

