/* =========================== START PROC BNLBD1 ======================== */
PROC (1)=BNLBD1(DATA,LEFT,RIGHT,NXGRID,ENDCT) ;
    /*  THIS DOES LINEAR BINNING OF THE VECTOR DATA,  */
    /*  FOR DENSITY ESTIMATION  */
    /*  LEFT AND RIGHT ARE THE FIRST AND LAST GRID CENTERS   */
    /*  NXGRID IS THE NUMBER OF BINS  */
    /*  ENDCT = 0, FOR TRUNCATING DATA BEYOND ENDS  */
    /*        = 1, FOR COUNTING DATA BEYOND ENDS IN END BIN  */
    /*  RETURN IS AN NXGRID VECTOR OF BIN COUNTS  */

 LOCAL BINWD,CENTS,FLAG,WTS,BINCTS ;

 BINWD = (RIGHT - LEFT) / (NXGRID - 1) ;      /*  BIN WIDTH  */
 CENTS = SEQA(LEFT,BINWD,NXGRID) ;            /*  VECTOR OF BIN CENTERS  */

 FLAG = -(DATA .<= LEFT) ;           /*  -1 FOR DATA POINTS BELOW RANGE  */
 FLAG = FLAG + (DATA .>= RIGHT) ;    /*  +1 FOR DATA POINTS ABOVE RANGE  */

 WTS = (DATA - LEFT) * (NXGRID - 1) / (RIGHT - LEFT) ;
                           /*  TRANSFORM [LEFT,RIGHT] TO [0,NXGRID-1]
                                      I.E. PUT "BIN CENTERS ON INTEGERS"  */
 WTS = WTS - FLOOR(WTS) ;            /*  DISTANCE TO NEXT LOWEST INTEGER  */
 WTS = WTS .* (ABS(FLAG) .<= .5) ;      /* 0 WEIGHT, EXCEPT IN "MIDRANGE" */

 BINCTS = COUNTWTS(DATA,CENTS,WTS) ;   /*  USE THIS DISTANCE AS WEIGHT
                                                   FOR NEXT GREATEST BIN  */

 WTS = 1 - WTS ;                   /*  DISTANCE TO NEXT GREATEST INTEGER  */
 WTS = WTS .* (ABS(FLAG) .<= .5) ;      /* 0 WEIGHT, EXCEPT IN "MIDRANGE" */
 BINCTS = BINCTS + REV(COUNTWTS(-DATA,REV(-CENTS),WTS)) ;
                                      /*  USE THIS DISTANCE AS WEIGHT
                                                   FOR NEXT SMALLEST BIN  */

 IF ENDCT == 1 ;               /*  COUNT IN OBSERVATIONS BEYOND EACH END  */
   BINCTS[1,1] = BINCTS[1,1] + SUMC(FLAG .< -.5) ;
   BINCTS[NXGRID,1] = BINCTS[NXGRID,1] + SUMC(FLAG .> .5) ;
 ENDIF ;            /*  OTHERWISE, OMIT THE OBSERVATIONS BEYOND THE ENDS  */

 RETP(BINCTS) ;
ENDP ;
/* ============================ END PROC BNLBD1 ========================= */
