/* =========================== START PROC BNLBR1 ======================== */
PROC (1)=BNLBR1(DATA,LEFT,RIGHT,NXGRID,ENDCT) ;
    /*  THIS DOES LINEAR BINNING OF THE NOBS x 2 MATRIX DATA,  */
    /*  FOR REGRESSION, WHERE X'S ARE IN FIRST COLUMN, Y'S IN SECOND  */
    /*  LEFT AND RIGHT ARE THE FIRST AND LAST GRID CENTERS   */
    /*  NXGRID IS THE NUMBER OF BINS  */
    /*  ENDCT = 0, FOR TRUNCATING DATA BEYOND ENDS  */
    /*        = 1, FOR COUNTING DATA BEYOND ENDS IN END BIN  */
    /*  RETURN IS AN NXGRID x 2 MATRIX,    */
    /*             WITH X BIN COUNTS IN FIRST COLUMN   */
    /*             AND WT'D TOTAL OF Y'S IN SECOND  */
    /*             FOR WT'D AVG OF Y'S, DIVIDE SECOND BY FIRST  */
    /*                    (BUT CAREFUL ABOUT 0/0)   */

 LOCAL BINWD,CENTS,FLAG,WTS,XBINCTS,YTOTS ;

 BINWD = (RIGHT - LEFT) / (NXGRID - 1) ;      /*  BIN WIDTH  */
 CENTS = SEQA(LEFT,BINWD,NXGRID) ;            /*  VECTOR OF BIN CENTERS  */

 FLAG = -(DATA[.,1] .<= LEFT) ;       /*  -1 FOR DATA POINTS BELOW RANGE  */
 FLAG = FLAG + (DATA[.,1] .>= RIGHT) ;/*  +1 FOR DATA POINTS ABOVE RANGE  */

 WTS = (DATA[.,1] - LEFT) * (NXGRID - 1) / (RIGHT - LEFT) ;
                           /*  TRANSFORM [LEFT,RIGHT] TO [0,NXGRID-1]
                                      I.E. PUT "BIN CENTERS ON INTEGERS"  */
 WTS = WTS - FLOOR(WTS) ;            /*  DISTANCE TO NEXT LOWEST INTEGER  */
 WTS = WTS .* (ABS(FLAG) .<= .5) ;      /* 0 WEIGHT, EXCEPT IN "MIDRANGE" */

 XBINCTS = COUNTWTS(DATA[.,1],CENTS,WTS) ;   /*  USE THIS DISTANCE AS WEIGHT
                                                   FOR NEXT GREATEST BIN  */
 YTOTS = COUNTWTS(DATA[.,1],CENTS,WTS.*DATA[.,2]) ;
                                    /*  FOR EACH BIN, TOTAL WEIGHTED Y'S  */

 WTS = 1 - WTS ;                   /*  DISTANCE TO NEXT GREATEST INTEGER  */
 WTS = WTS .* (ABS(FLAG) .<= .5) ;      /* 0 WEIGHT, EXCEPT IN "MIDRANGE" */
 XBINCTS = XBINCTS + REV(COUNTWTS(-DATA[.,1],REV(-CENTS),WTS)) ;
                                      /*  USE THIS DISTANCE AS WEIGHT
                                                   FOR NEXT SMALLEST BIN  */
 YTOTS = YTOTS + REV(COUNTWTS(-DATA[.,1],REV(-CENTS),WTS.*DATA[.,2])) ;
                                    /*  FOR EACH BIN, TOTAL WEIGHTED Y'S  */

 IF ENDCT == 1 ;               /*  COUNT IN OBSERVATIONS BEYOND EACH END  */
   XBINCTS[1,1] = XBINCTS[1,1] + SUMC(FLAG .< -.5) ;
   XBINCTS[NXGRID,1] = XBINCTS[NXGRID,1] + SUMC(FLAG .> .5) ;
   YTOTS[1,1] = YTOTS[1,1] + SUMC((FLAG .< -.5) .* DATA[.,2]) ;
   YTOTS[NXGRID,1] = YTOTS[NXGRID,1] + SUMC((FLAG .> .5) .* DATA[.,2]) ;
 ENDIF ;            /*  OTHERWISE, OMIT THE OBSERVATIONS BEYOND THE ENDS  */

 RETP(XBINCTS~YTOTS) ;
ENDP ;
/* ============================ END PROC BNLBR1 ========================= */
