/* =========================== START PROC BNLLR2 ======================== */
PROC BNLLR2(BINCTS,LEFT,RIGHT,H,IKER,KPAR,ETA) ;
   /*  BINNED CALCULATION OF LOCAL LINEAR ESTIMATE OF REGRESSION  */
   /*  MODIFIES BNLLR1, BY DOING RIDGED VERSION     */
   /*  BINCTS SHOULD CONTAIN BIN COUNTS FOR AN EQUALLY SPACED  */
   /*      GRID OF BINS STARTING AT LEFT, ENDING AT RIGHT,  */
   /*             WITH X BIN COUNTS IN FIRST COLUMN   */
   /*             AND WT'D TOTAL OF Y'S IN SECOND  */
   /*      AS GIVEN BY BNLBR1.G     */
   /*  FOR EQUALLY SPACED X'S, AND A RETURN AT THOSE X'S ONLY,  */
   /*  USE ONES IN FIRST COLUMN OF BINCNTS, AND Y'S IN THE SECOND  */
   /*                                                        */
   /*  H IS THE BANDWIDTH, MUST BE A SCALAR    */
   /*  IKER = 1  -  STANDARD NORMAL   */
   /*            KPAR HAS NO EFFECT   */
   /*  IKER = 2  -  BETA, SUPPORTED [-1,1], WITH  */
   /*            KPAR = 0  -  UNIFORM   */
   /*            KPAR = 1  -  EPANECHNIKOV   */
   /*            KPAR = 2  -  BIWEIGHT   */
   /*            KPAR = 3  -  TRIWEIGHT   */
   /*  ETA IS RIDGE PARAMETER   (NUMERATOR / (DENOMINATOR + ETA))  */
   /*  OUTPUT IS A MATRIX,       */
   /*  FIRST COLUMN IS HEIGHTS OF THE ESTIMATE, AT BIN CENTERS  */
   /*  SECOND COLUMN IS THE KERNEL FUNCTION USED   */
   /*  CAUTION, KERNEL ONLY GIVES SHAPE AND WILL NEED RESCALING  */

 LOCAL NXGRID,DELTA,K,ARG,KVEC0,KVEC1,KVEC2,S0,S1,S2,DENOM,MHAT ;


 NXGRID = ROWS(BINCTS) ;               /*  NUMBER OF GRIDPOINTS  */
 DELTA = (RIGHT - LEFT) / (NXGRID - 1) ;     /*  BINWIDTH  */


 IF IKER == 1 ;        /*  WORK WITH GAUSSIAN FAMILY  */

   K = NXGRID - 1 ;
        /*  INDEX OF LAST NONZERO ENTRY IN KERNEL VECTOR  */

   ARG = SEQA(0,DELTA/H,K+1) ;
   KVEC0 = PDFN(ARG) ;
 ELSEIF IKER == 2 ;

   K = MINC(FLOOR(H / DELTA)|(NXGRID - 1)) ;
        /*  INDEX OF LAST NONZERO ENTRY IN KERNEL VECTOR  */

   ARG = SEQA(0,DELTA/H,K+1) ;

   IF KPAR == 0 ;      /*  UNIFORM KERNEL  */
     KVEC0 = ONES(K+1,1) ;
     KVEC0 = KVEC0 * (1 / 2) ;              /*  CONSTANT FROM MARRON-NOLAN  */
   ELSE ;
     KVEC0 = 1 - ARG .* ARG ;
     IF KPAR == 1 ;     /*  EPANECHNIKOV KERNEL  */
       KVEC0 = KVEC0 * (3 / 4) ;            /*  CONSTANT FROM MARRON-NOLAN  */
     ELSEIF KPAR == 2 ;    /*  BIWEIGHT KERNEL  */
       KVEC0 = KVEC0 .* KVEC0 ;
       KVEC0 = KVEC0 .* (15 / 16) ;         /*  CONSTANT FROM MARRON-NOLAN  */
     ELSEIF KPAR == 3 ;    /*  TRIWEIGHT KERNEL  */
       KVEC0 = KVEC0 .* KVEC0 .* KVEC0 ;
       KVEC0 = KVEC0 .* (35 / 32) ;         /*  CONSTANT FROM MARRON-NOLAN  */
     ELSE ;               /*  USE MARRON-NOLAN GENERAL FORMULA  */
       KVEC0 = KVEC0^KPAR ;
       KVEC0 = KVEC0 .* (GAMMA(2*KPAR+2) * GAMMA(KPAR+1)^(-2) * 2^(-2*KPAR-1)) ;
     ENDIF ;
   ENDIF ;

 ENDIF ;

 ARG = ARG * H ;
 KVEC1 = KVEC0 .* ARG ;
 KVEC2 = KVEC1 .* ARG ;
   ARG = 0 ;           /*  TO SAVE SPACE  */

 KVEC0 = REV(KVEC0[2:K+1])|KVEC0 ;        /*  CONSTRUCT SYMMETRIC KERNEL  */
 KVEC1 = -REV(KVEC1[2:K+1])|KVEC1 ;       /*  SKEW-SYMMETRIC HERE!    */
 KVEC2 = REV(KVEC2[2:K+1])|KVEC2 ;

 S0 = CONV(BINCTS[.,1],KVEC0,K+1,K+NXGRID) ;
 S1 = CONV(BINCTS[.,1],KVEC1,K+1,K+NXGRID) ;
 S2 = CONV(BINCTS[.,1],KVEC2,K+1,K+NXGRID) ;
   KVEC2 = 0 ;         /*  TO SAVE SPACE  */

 DENOM = S2 .* S0 - S1 .* S1 ;
   S0 = 0 ;           /*  TO SAVE SPACE  */
 DENOM = DENOM + ETA ;


 MHAT = S2 .* CONV(BINCTS[.,2],KVEC0,K+1,K+NXGRID) ;
   S2 = 0 ;         /*  TO SAVE SPACE  */

 MHAT = MHAT  -  S1 .* CONV(BINCTS[.,2],KVEC1,K+1,K+NXGRID) ;
 MHAT = MHAT ./ DENOM ;

              /*  ADJUST LENGTH OF KVEC0 TO BE NXGRID  */
 K = ROWS(KVEC0) - NXGRID ;
 IF K > 0 ;        /*  NEED TO TRUNCATE KVEC0  */
   K = CEIL(K / 2) ;
   KVEC0 = KVEC0[K+1:K+NXGRID] ;
 ELSEIF K < 0 ;        /*  NEED TO PAD KVEC0 WITH ZEROS  */
   K = CEIL(-K / 2) ;
   KVEC0 = ZEROS(K,1)|KVEC0 ;
   KVEC0 = KVEC0|ZEROS(NXGRID - ROWS(KVEC0),1) ;
 ENDIF ;

 RETP(MHAT~KVEC0) ;
ENDP ;
/* ============================ END PROC BNLLR2 ======================== */
