/* =========================== START PROC BNNWR1 ======================== */
PROC BNNWR1(BINCTS,LEFT,RIGHT,H,IKER,KPAR) ;
   /*  BINNED CALCULATION OF NADARYA WATSON ESTIMATE OF REGRESSION  */
   /*  BINCTS SHOULD CONTAIN BIN COUNTS FOR AN EQUALLY SPACED  */
   /*      GRID OF BINS STARTING AT LEFT, ENDING AT RIGHT,  */
   /*             WITH X BIN COUNTS IN FIRST COLUMN   */
   /*             AND WT'D TOTAL OF Y'S IN SECOND  */
   /*      AS GIVEN BY BNLBR1.G     */
   /*  FOR EQUALLY SPACED X'S, AND A RETURN AT THOSE X'S ONLY,  */
   /*  USE ONES IN FIRST COLUMN OF BINCNTS, AND Y'S IN THE SECOND  */
   /*                                                        */
   /*  H IS THE BANDWIDTH, MUST BE A SCALAR    */
   /*  IKER = 1  -  GAUSSIAN HIGHER ORDER FAMILY    */
   /*            KPAR = 2  -  STANDARD NORMAL   */
   /*            KPAR = 4  -  GRAM CHARLIER, ORDER 4   */
   /*            KPAR = 6  -  GRAM CHARLIER, ORDER 6   */
   /*  IKER = 2  -  BETA, SUPPORTED [-1,1], WITH  */
   /*            KPAR = 0  -  UNIFORM   */
   /*            KPAR = 1  -  EPANECHNIKOV   */
   /*            KPAR = 2  -  BIWEIGHT   */
   /*            KPAR = 3  -  TRIWEIGHT   */
   /*  OUTPUT IS A MATRIX,       */
   /*  FIRST COLUMN IS HEIGHTS OF THE ESTIMATE, AT BIN CENTERS  */
   /*  SECOND COLUMN IS THE KERNEL FUNCTION USED   */
   /*  CAUTION, KERNEL ONLY GIVES SHAPE AND WILL NEED RESCALING  */

 LOCAL NXGRID,DELTA,K,R,CS,ARG,NARG,HP,HPN,KVEC,IS,DENOM,MHAT ;


 NXGRID = ROWS(BINCTS) ;               /*  NUMBER OF GRIDPOINTS  */
 DELTA = (RIGHT - LEFT) / (NXGRID - 1) ;     /*  BINWIDTH  */


 IF IKER == 1 ;        /*  WORK WITH GAUSSIAN FAMILY  */

   K = NXGRID - 1 ;
        /*  INDEX OF LAST NONZERO ENTRY IN KERNEL VECTOR  */

   R = KPAR / 2 ;                             /*  CONVENIENT FOR HERMITES  */
   CS = SEQM(1,-.5,R) ./ SEQA(0,1,R)! ;       /*  COEFFS FOR HERMITES  */

   ARG = SEQA(0,DELTA/H,K+1) ;

   NARG = PDFN(ARG) ;

   IF KPAR > 2 ;
     HP = ONES(ROWS(ARG),COLS(ARG)) ;       /*  0TH HERMITE POLY  */
     HPN = ARG ;                         /*  1ST HERMITE POLY  */
     KVEC = HP .* NARG ;
     IS = 1 ;
     DO WHILE IS <= (R - 1) ;
       HP = ARG .* HPN - (2*IS - 1) * HP ;   /* (2*IS)-TH HERMITE POLY  */
       HPN = ARG .* HP - (2*IS) * HPN ;   /*  (2*IS+1)-TH HERMITE POLY  */
       KVEC = KVEC~(HP .* NARG) ;
       IS = IS + 1 ;
     ENDO ;
     KVEC = KVEC * CS ;         /*  SUM ON S   */

     HP = 0 ;  HPN = 0 ;      /*  TO SAVE SPACE  */
   ELSE ;
     KVEC = NARG ;
   ENDIF ;

   NARG = 0 ;      /*  TO SAVE SPACE  */
 ELSEIF IKER == 2 ;

   K = MINC(FLOOR(H / DELTA)|(NXGRID - 1)) ;
        /*  INDEX OF LAST NONZERO ENTRY IN KERNEL VECTOR  */

   IF KPAR == 0 ;      /*  UNIFORM KERNEL  */
     KVEC = ONES(K+1,1) ;
     KVEC = KVEC * (1 / 2) ;              /*  CONSTANT FROM MARRON-NOLAN  */
   ELSE ;
     ARG = SEQA(0,DELTA/H,K+1) ;
     KVEC = 1 - ARG .* ARG ;
     IF KPAR == 1 ;     /*  EPANECHNIKOV KERNEL  */
       KVEC = KVEC * (3 / 4) ;            /*  CONSTANT FROM MARRON-NOLAN  */
     ELSEIF KPAR == 2 ;    /*  BIWEIGHT KERNEL  */
       KVEC = KVEC .* KVEC ;
       KVEC = KVEC .* (15 / 16) ;         /*  CONSTANT FROM MARRON-NOLAN  */
     ELSEIF KPAR == 3 ;    /*  TRIWEIGHT KERNEL  */
       KVEC = KVEC .* KVEC .* KVEC ;
       KVEC = KVEC .* (35 / 32) ;         /*  CONSTANT FROM MARRON-NOLAN  */
     ELSE ;               /*  USE MARRON-NOLAN GENERAL FORMULA  */
       KVEC = KVEC^KPAR ;
       KVEC = KVEC .* (GAMMA(2*KPAR+2) * GAMMA(KPAR+1)^(-2) * 2^(-2*KPAR-1)) ;
     ENDIF ;
   ENDIF ;

 ENDIF ;
   ARG = 0 ;           /*  TO SAVE SPACE  */

 KVEC = REV(KVEC[2:K+1])|KVEC ;        /*  CONSTRUCT SYMMETRIC KERNEL  */

 DENOM = CONV(BINCTS[.,1],KVEC,K+1,K+NXGRID) ;

 IF SUMC(DENOM .== 0) ;     /*  IF ANY ELT OF DENOM IS 0  */
   "*****************************************************************" ;
   "***                                                           ***" ;
   "***    WARNING: h is too small for smoothing this data set    ***" ;
   "***                                                           ***" ;
   "*****************************************************************" ;
   RETP(0) ;
 ENDIF ;

 MHAT = CONV(BINCTS[.,2],KVEC,K+1,K+NXGRID) ;
 MHAT = MHAT ./ DENOM ;

              /*  ADJUST LENGTH OF KVEC TO BE NXGRID  */
 K = ROWS(KVEC) - NXGRID ;
 IF K > 0 ;        /*  NEED TO TRUNCATE KVEC  */
   K = CEIL(K / 2) ;
   KVEC = KVEC[K+1:K+NXGRID] ;
 ELSEIF K < 0 ;        /*  NEED TO PAD KVEC WITH ZEROS  */
   K = CEIL(-K / 2) ;
   KVEC = ZEROS(K,1)|KVEC ;
   KVEC = KVEC|ZEROS(NXGRID - ROWS(KVEC),1) ;
 ENDIF ;

 RETP(MHAT~KVEC) ;
ENDP ;
/* ============================ END PROC BNNWR1 ======================== */
