/* =========================== START PROC BNPITFH ======================== */
PROC BNPITFH(BINCTS,LEFT,RIGHT,H) ;
   /*  BINNED CALCULATION OF PROBABLITY INTEGRAL TRANSFORMED  */
   /*  DATA, WHERE THE TRANSFO IS BASED ON THE KDE  */
   /*  BINCTS SHOULD CONTAIN BIN COUNTS FOR AN EQUALLY SPACED  */
   /*      GRID OF BINS STARTING AT LEFT, ENDING AT RIGHT,  */
   /*      AS GIVEN BY BNLBD1.G     */
   /*  H IS THE BANDWIDTH, MUST BE A SCALAR    */
   /*  THE KERNEL IS GAUSSIAN  */
   /*  OUTPUT IS A VECTOR,       */
   /*    THE TRANSFORMED (TOWARDS UNIFORMITY) BIN CENTERS  */
   /*        NOTE THESE WILL NO LONGER BE EQUALLY SPACED  */
   /*        OUTPUT IS INTENDED TO GO RIGHT INTO BNCMV.G  */

 LOCAL NOBS,NXGRID,DELTA,K,ARG,KVEC,IS,TGRID ;


 NOBS = SUMC(BINCTS) ;                 /*  NUMBER OF DATA POINTS  */
 NXGRID = ROWS(BINCTS) ;               /*  NUMBER OF GRIDPOINTS  */
 DELTA = (RIGHT - LEFT) / (NXGRID - 1) ;     /*  BINWIDTH  */


 K = NXGRID - 1 ;
        /*  INDEX OF LAST NONZERO ENTRY IN KERNEL VECTOR  */
 ARG = SEQA(-K,1,(2*K)+1) ;
 ARG = ARG * (DELTA / H) ;
 KVEC = CDFN(ARG) ;

 TGRID = CONV(BINCTS,KVEC,K+1,K+NXGRID) ;
 TGRID = TGRID / NOBS ;

 RETP(TGRID) ;
ENDP ;
/* ============================ END PROC BNPITFH ======================== */

