/*============================ START PROC CEME =========================*/
PROC CEME(DELX,VF,LAMBDA) ;
  /*  THIS FINDS ORDERED COMPONENTS E FOR    */
  /*  THE CONTINUOUS EXCESS MASS STATISTIC  */
  /*  INPUTS ARE:                       */
  /*      DELX IS THE BINWIDTH OF THE EQUALLY SPACED GRID     */
  /*              OF X VALUES, WHERE THE DENSITY IS EVALUATED  */
  /*      VF IS A VECTOR OF FUNCTION VALUES, A DISCRETIZATION  */
  /*              OF THE CONTINUOUS FUNCTION   */
  /*      LAMBDA IS THE THRESHOLD VALUE     */
  /*  OUTPUT IS A VECTOR, WHERE EACH ENTRY IS THE MASS OF THE  */
  /*           DENSITY ABOVE THE THRESHOLD LAMBDA, FOR A LOCAL MODE,   */
  /*           IN ORDER OF DECREASING MAGNITUDE       */
  /*           RETURNS A SCALAR 0 IF VF NEVER ABOVE LAMBDA  */

  LOCAL VIS,VIE,VE,VFML,L,I ;

  VIS = EMECIG(VF,LAMBDA) ;
  VIE = VIS[.,2] ;      /*  VECTOR OF STARTING INDICES  */
  VIS = VIS[.,1] ;      /*  VECTOR OF ENDING INDICES  */

  IF VIS[1,1] == 0 ;
    VE = 0 ;
  ELSE ;
    VFML = VF - LAMBDA ;    /*  VECTOR TO INTEGRATE  */

    L = ROWS(VIS) ;
    VE = ZEROS(L,1) ;
    I = 1 ;
    DO WHILE I <= L ;
      VE[I] = DELX * SUMC(   VFML[ VIS[I]:VIE[I] ]   ) ;
      I = I + 1 ;
    ENDO ;

    VE = SORTC(VE,1) ;
    VE = REV(VE) ;
  ENDIF ;


  RETP(VE) ;
ENDP ;
/*============================= END PROC CEME ==========================*/

