/* =========================== START PROC CGEOAVG ======================= */
PROC CGEOAVG(CX1,CX2,ALPHA) ;
   /*  THIS CALCULATES THE COMPLEX GEOMETRIC WEIGHTED AVERAGE    */
   /*  OF COMPLEX MATRICES, WITH WEIGHT ALPHA   */
   /*  THIS FINDS THE CORRECT BRANCH OF THE POWER FUNCTION        */
   /*           (ESSENTIALLY BRANCH OF THE COMPLEX LOG FUNCTION  */
   /*  TO CALCULATE:                 */
   /*            CX1^ALPHA .* CX2^(1-ALPHA)   */
   /*  INPUTS:            */
   /*    CX1 - COMPLEX MATRIX    */
   /*    CX2 - COMPLEX MATRIX, SAME DIMENSIONS AS CX1    */
   /*    ALPHA - WEIGHT, ASSUMED TO BE A SCALAR    */
   /*  OUTPUT:           */
   /*    CXAVG - ALPHA WEIGHTED GEOMETRIC AVERAGE OF CX1 AND CX2     */

 LOCAL MOD1,MOD2,FLAG0,CXAVG,ANG1,ANG2,FLAG,ARG ;

     /*  FIRST WORK WITH COMPLEX MODULI   */
 MOD1 = ABS(CX1) ;   /*  COMPLEX MODULUS  */
 MOD2 = ABS(CX2) ;

 FLAG0 = (ABS(MOD1) .> 10^(-100)) .* (ABS(MOD2) .> (10^(-100))) ;
                     /*  0 WHERE EITHER IS ZERO  */
 MOD1 = (1 - FLAG0) + FLAG0 .* MOD1 ;     /* REPLACE ZEROS BY 1  */
 MOD2 = (1 - FLAG0) + FLAG0 .* MOD2 ;     /* REPLACE ZEROS BY 1  */

     /*  MODULS PART OF AVERAGE   */
 CXAVG = MOD1^ALPHA .* MOD2^(1-ALPHA) ;

     /*  NOW WORK WITH COMPLEX ANGLES  */
 ANG1 = ATAN2(IMAG(CX1),REAL(CX1)) ;    /*  ANGLES OF COMPLEX NUMBERS  */
 ANG2 = ATAN2(IMAG(CX2),REAL(CX2)) ;    /*  ON THE SCALE [-PI,PI]    */

 FLAG = ABS(ANG2 - ANG1) .> PI ;   /*  1 WHERE CAN BE ON OPPOSITE BRANCH */
 ANG1 = ANG1 + FLAG .* (ANG1 .< 0) .* (2 * PI) ;
            /*  IF ARE OPPOSITE, AND THIS IS NEGATIVE, ADD 2 PI  */

 ANG2 = ANG2 + FLAG .* (ANG2 .< 0) .* (2 * PI) ;
            /*  IF ARE OPPOSITE, AND THIS IS NEGATIVE, ADD 2 PI  */

     /* ANGLE PART OF AVERAGE  */
 ARG = ALPHA .* ANG1 + (1 - ALPHA) .* ANG2 ;
 ARG = COMPLEX(ZEROS(ROWS(CX1),COLS(CX1)),ARG) ;
 CXAVG = CXAVG .* EXP(ARG) ;


    /*  REPLACE WITH 0'S WHERE EITHER WAS 0  */
 CXAVG = FLAG0 .* CXAVG ;

 RETP(CXAVG) ;
ENDP ;
/* ============================ END PROC CGEOAVG ======================= */

