/* =========================== START PROC CHOADDC ========================= */
PROC (3)=CHOADDC(CHOXPX,XPX,X,XNEW) ;
    /*  THIS DOES AN UPDATE OF THE CHOLESKY DECOMPOSITION OF X'X   */
    /*  WHEN A COLUMN IS ADDED TO THE ORIGINAL X MATRIX    */
    /*  INPUTS:                                */
    /*      X        -  DESIGN MATRIX TO BE UPDATED    */
    /*      XPX      -  X' * X TO BE UPDATED     */
    /*      CHOXPX   -  CHOLESKY DECOMPOSTION OF X   */
    /*      XNEW     -  NEW COLUMN TO ADD TO LEFT OF X   */
    /*  OUTPUTS:                                          */
    /*      XB       -  BIG VERSION OF X        */
    /*      XBPXB    -  UPDATED VERSION OF X' * X     */
    /*      CHOXBPXB -  UPDATED SHOLESKY DECOMPOSITION   */

  LOCAL R,XB,X12,X22,XBPXB,CREV,C12,C22,CHOXBPXB ;

  R = COLS(X) ;
  XB = X~XNEW ;


             /*  UPDATE XPX   */
  X12 = X' * XNEW ;
  X22 = XNEW' * XNEW ;

  XBPXB = XPX~X12 ;
  XBPXB = XBPXB|(X12'~X22) ;


             /*  UPDATE CHOLESKY DECOMP   */
  CREV = REV( REV(CHOXPX)' ) ;
  C12 = REV(CHOLSOL(CREV' * REV(X12) , CREV)) ;
  C22 = SQRT(XNEW' * XNEW - C12' * C12) ;

  CHOXBPXB = CHOXPX~(C12) ;
  CHOXBPXB = CHOXBPXB|(ZEROS(1,R)~C22) ;


  RETP(XB,XBPXB,CHOXBPXB) ;
ENDP;
/* ====================== END PROCEDURE CHOADDC =========================== */
