/* =========================== START PROC CHOADDCU ========================= */
PROC (1)=CHOADDCU(CHOXSPXS,XFPXF,VICOLXS,ICOLNEW) ;
    /*  THIS DOES AN UPDATE OF THE CHOLESKY DECOMPOSITION OF X'X   */
    /*  WHEN A COLUMN IS ADDED TO AN X MATRIX    */
    /*  WHICH IS A SUBMATRIX OF A BIGGER ONE, XF   */
    /*  IF RESULT WILL BE COMPLEX, THEN DOES FULL CHOLESKY  */
    /*  INPUTS:                                */
    /*      CHOXSPXS   -  CHOLESKY DECOMPOSTION OF XS'XS   */
    /*      XFPXF    -  XF' * XF,  FOR FULL DESIGN MATRIX     */
    /*      VICOLXS  -  INDICES OF COLUMNS CURRENTLY IN XS      */
    /*      ICOLNEW  -  INDEX OF NEW COLUMN TO ADD TO LEFT OF XS   */
    /*  OUTPUT:                                             */
    /*      CHOXBPXB -  UPDATED SHOLESKY DECOMPOSITION   */

  LOCAL R,X12,X22,CREV,C12,ARG,C22,CHOXBPXB ;

  R = COLS(CHOXSPXS) ;

             /*  NEW PARTS OF XBPXB   */
  X12 = XFPXF[VICOLXS,ICOLNEW] ;
  X22 = XFPXF[ICOLNEW,ICOLNEW] ;


             /*  UPDATE CHOLESKY DECOMP   */
  CREV = REV( REV(CHOXSPXS)' ) ;
  C12 = REV(CHOLSOL(CREV' * REV(X12) , CREV)) ;
  ARG = X22 - C12' * C12 ;

  IF ARG > 0 ;     /*  NO NUMERICAL TROUBLES, UPDATE  */
    C22 = SQRT(ARG) ;
    CHOXBPXB = CHOXSPXS~(C12) ;
    CHOXBPXB = CHOXBPXB|(ZEROS(1,R)~C22) ;
  ELSE ;      /*  WILL GET SINGULAR RESULT, SO DO DIRECT CHOLESKY  */
    CHOXBPXB = CHOL(XFPXF[VICOLXS|ICOLNEW,VICOLXS|ICOLNEW]) ;
  ENDIF ;


  RETP(CHOXBPXB) ;
ENDP;
/* ====================== END PROCEDURE CHOADDCU =========================== */

