/* =========================== START PROC CHODELC ========================= */
PROC (3)=CHODELC(CHOXPX,XPX,X,ICOL) ;
    /*  THIS DOES AN UPDATE OF THE CHOLESKY DECOMPOSITION OF X'X   */
    /*  WHEN A COLUMN IS DELETED FROM THE ORIGINAL X MATRIX    */
    /*  INPUTS:                                */
    /*      X        -  DESIGN MATRIX TO BE UPDATED    */
    /*      XPX      -  X' * X TO BE UPDATED     */
    /*      CHOXPX   -  CHOLESKY DECOMPOSTION OF X   */
    /*      ICOL     -  INDEX OF COLUMN TO BE DELETED   */
    /*                        (ASSUMED SMALLER THAN COLS OF X)    */
    /*  OUTPUTS:                                          */
    /*      XS       -  SMALL VERSION OF X        */
    /*      XSPXS    -  UPDATED VERSION OF X' * X     */
    /*      CHOXSPXS -  UPDATED SHOLESKY DECOMPOSITION   */
    /*  NOTE: RUNS FASTER FOR ICOL LARGER     */

  LOCAL R,XS,XSPXS,CHOXSPXS,X1PX1,X1PX2,X2PX2,C11,CREV,REVB,C12,C22 ;

  R = COLS(X) ;

  IF ICOL == 1 ;     /*  FIRST COLUMN  */
    XS = X[.,2:R] ;
    XSPXS = XPX[2:R,2:R] ;
    CHOXSPXS = CHOL(XSPXS) ;
            /*  DON'T KNOW FASTER WAY, BUT MIGHT BE ONE, BY SYMMETRY   */

  ELSEIF ICOL == R ;    /*  LAST COLUMN   */
    XS = X[.,1:R-1] ;
    XSPXS = XPX[1:R-1,1:R-1] ;
    CHOXSPXS = CHOXPX[1:R-1,1:R-1] ;

  ELSE ;
    XS = X[.,1:ICOL-1]~X[.,ICOL+1:R] ;

    X1PX1 = XPX[1:ICOL-1,1:ICOL-1] ;
    X1PX2 = XPX[1:ICOL-1,ICOL+1:R] ;
    X2PX2 = XPX[ICOL+1:R,ICOL+1:R] ;
    XSPXS = X1PX1~X1PX2 ;
    XSPXS = XSPXS|(X1PX2'~X2PX2) ;

    C11 = CHOXPX[1:ICOL-1,1:ICOL-1] ;
    CREV = REV( REV(C11)' ) ;
    REVB = REV(X1PX2) ;
    C12 = REV(CHOLSOL(CREV' * REVB , CREV)) ;
    C22 = CHOL(X2PX2 - C12' * C12) ;
    CHOXSPXS = C11~C12 ;
    CHOXSPXS = CHOXSPXS|(ZEROS(R-ICOL,ICOL-1)~C22) ;

  ENDIF ;


  RETP(XS,XSPXS,CHOXSPXS) ;
ENDP;
/* ====================== END PROCEDURE CHODELC =========================== */
