/* =========================== START PROC CHODELCU ========================= */
PROC (1)=CHODELCU(CHOXBPXB,XFPXF,VICOLXB,ICOLDEL) ;
    /*  THIS DOES AN UPDATE OF THE CHOLESKY DECOMPOSITION OF X'X   */
    /*  WHEN A COLUMN IS DELETED FROM AN X MATRIX    */
    /*  WHICH IS A SUBMATRIX OF A BIGGER ONE, XF   */
    /*  INPUTS:                                */
    /*      CHOXBPXB   -  CHOLESKY DECOMPOSTION OF XB'XB   */
    /*      XFPXF    -  XF' * XF,  FOR FULL DESIGN MATRIX, XF     */
    /*      VICOLXB  -  INDICES OF COLUMNS OF XF CURRENTLY IN XB      */
    /*      ICOLDEL     -  INDEX OF COLUMN OF XF TO BE DELETED   */
    /*                        (ASSUMED ONE OF VICOLXB)    */
    /*  OUTPUTS:                                          */
    /*      CHOXSPXS -  UPDATED SHOLESKY DECOMPOSITION   */
    /*  NOTE: RUNS FASTER FOR ICOLDEL CLOSER TO END OF VICOLXB     */

  LOCAL R,IDEL,CHOXSPXS,X1PX1,X1PX2,X2PX2,C11,CREV,REVB,C12,C22 ;

  R = COLS(CHOXBPXB) ;

  IDEL = MAXINDC(VICOLXB .== ICOLDEL) ;      /* INDEX OF COL IN VICOLXB  */

  IF IDEL == 1 ;     /*  FIRST COLUMN IS COLUMN TO DELETE  */
    CHOXSPXS = CHOL(XFPXF[VICOLXB[2:R],VICOLXB[2:R]]) ;
            /*  DON'T KNOW FASTER WAY, BUT MAY BE ONE, BY SYMMETRY   */

  ELSEIF IDEL == R ;    /*  LAST COLUMN IS COLUMN TO DELETE    */
    CHOXSPXS = CHOXBPXB[1:R-1,1:R-1] ;

  ELSE ;

    X1PX2 = XFPXF[VICOLXB[1:IDEL-1],VICOLXB[IDEL+1:R]] ;
    X2PX2 = XFPXF[VICOLXB[IDEL+1:R],VICOLXB[IDEL+1:R]] ;

    C11 = CHOXBPXB[1:IDEL-1,1:IDEL-1] ;
    CREV = REV( REV(C11)' ) ;
    REVB = REV(X1PX2) ;

    C12 = REV(CHOLSOL(CREV' * REVB , CREV)) ;
    C22 = CHOL(X2PX2 - C12' * C12) ;
    CHOXSPXS = C11~C12 ;
    CHOXSPXS = CHOXSPXS|(ZEROS(R-IDEL,IDEL-1)~C22) ;

  ENDIF ;


  RETP(CHOXSPXS) ;
ENDP;
/* ====================== END PROCEDURE CHODELCU =========================== */
