/* =========================== START PROC CISIM1 ======================= */
PROC CISIM1(MCURVE,ALPHA,TOLFAC) ;
   /*  CALCULATES INNER AND OUTER ENVELOPES OF FAMILIES OF CURVES  */
   /*  FOR USE IN CALCULATING BOOTSTRAP SIMULTANEOUS       */
   /*                                 AND POINTWISE CONFIDENCE BANDS     */
   /*  SIMULTANEOUS BANDS ARE CHOSEN SO THAT POINTWISE QUANTILES   */
   /*      ARE THE SAME, AND LARGE ENOUGH TO GIVE SIMULTANEOUS COVERAGE  */
   /*  INPUTS:            */
   /*    MCURVE - MATRIX OF CURVES, IN COLUMNS (AS FOR PLOTTING)  */
   /*    ALPHA  - TAIL OF COVERAGE PROBABILITY, E.G. ALPHA = .10  */
   /*                 GIVES ENVELOPE WITH 90% COVERAGE   */
   /*    TOLFAC - TOLERANCE FACTOR, WILL GET WITHIN     */
   /*                   TOLFAC / N  OF CORRECT COVERAGE  */
   /*  OUPTUT:           */
   /*    MATRIX WITH COLUMNS:        */
   /*            LOWER SIMULTANEOUS ENVELOPE    */
   /*            UPPER SIMULTANEOUS ENVELOPE    */
   /*            LOWER POINTWISE ENVELOPE    */
   /*            UPPER POINTWISE ENVELOPE    */

 LOCAL NGRID,NCURVE,IGRID,SMCURVE,LOPW,UPPW,BETAMIN,BETAMAX,UPENV,
           BETA,IBETA,COVERP,LOENV ;

 NGRID = ROWS(MCURVE) ;
 NCURVE = COLS(MCURVE) ;


 /*    CALCULATING SORTED VERSION OF MCURVE   */
 IGRID = 1 ;
 SMCURVE = ZEROS(NGRID,NCURVE) ;
 DO WHILE IGRID <= NGRID ;
/*
    "." ;;
*/
   SMCURVE[IGRID,.] = SORTC(MCURVE[IGRID,.]',1)' ;
   IGRID = IGRID + 1 ;
 ENDO ;
/*
  ? ;
*/

 LOPW = CQUANT2(SMCURVE,ALPHA/2) ;
 UPPW = CQUANT2(SMCURVE,1 - ALPHA/2) ;


       /*            CALCULATING UPPER ENVELOPE       */
       /*  IDEA:  FOR POINTWISE COVERAGE LEVEL  BETA,           */
       /*  CALCULATE SIMULTANEOUS COVERAGE, THEN ADJUST  BETA   */
       /*  TO MAKE COVERAGE 1 - ALPHA                           */
 BETAMIN = 1 - ALPHA / 2 ;       /*  SINCE ONLY ONE SIDED  */
 BETAMAX = 1 ;
 DO WHILE (BETAMAX - BETAMIN) >= (TOLFAC / NCURVE) ;
   BETA = (BETAMAX + BETAMIN) / 2 ;       /*  BISECTION METHOD  */
/*
    "           DOING A BETA IMPROVEMENT STEP, BETA = " BETA ;
*/
   UPENV = CQUANT2(SMCURVE,BETA) ;
   COVERP = CPROB2(SMCURVE,UPENV) ;
   COVERP = MINC(COVERP) ;
   IF COVERP >= 1 - ALPHA / 2 ;      /*   TOO MANY CURVES BELOW  */
     BETAMAX = BETA ;
   ELSE ;                              /*   TOO FEW CURVES BELOW  */
     BETAMIN = BETA ;
   ENDIF ;
 ENDO ;

       /*            CALCULATING LOWER ENVELOPE       */
 BETAMIN = 0 ;
 BETAMAX = ALPHA / 2 ;
 DO WHILE (BETAMAX - BETAMIN) >= (TOLFAC / NCURVE) ;
   BETA = (BETAMAX + BETAMIN) / 2 ;       /*  BISECTION METHOD  */
/*
    "           DOING A BETA IMPROVEMENT STEP, BETA = " BETA ;
*/
   LOENV = CQUANT2(SMCURVE,BETA) ;
   COVERP = CPROB2(SMCURVE,LOENV) ;
   COVERP = MAXC(COVERP) ;
   IF COVERP >= ALPHA / 2 ;      /*   TOO MANY CURVES BELOW  */
     BETAMAX = BETA ;
   ELSE ;                              /*   TOO FEW CURVES BELOW  */
     BETAMIN = BETA ;
   ENDIF ;

 ENDO ;

 RETP(LOENV~UPENV~LOPW~UPPW) ;
ENDP ;
/* ============================ END PROC CISIM ======================= */

