/* =========================== START PROC CPROB2 ======================= */
PROC CPROB2(MXORDER,VQUANT) ;
   /*  THIS CALCULATES A CONTINUOUS VERSION OF PROBABILITY,   */
   /*  BASED ON ONLY A SET OF ORDER STATISTICS FROM THE    */
   /*  GIVEN DISTRIBUTION     */
   /*         THIS THE C.D.F. WHICH IS THE "INVERSE FUNCTION"     */
   /*         OF THE QUANTILE FUNCTION IN CQUANT2.G     */
   /*  INPUTS:            */
   /*    MXORDER - MATRIX OF ORDER STATISTICS  */
   /*             !!! assumed in increasing order along rows   !!!   */
   /*    VQUANT  - VECTOR OF QUANTILES WHOSE (EMPIRICAL PROB)      */
   /*                         IS TO BE FOUND FOR EACH ROW OF X'S     */
   /*                    SHOULD HAVE SAME NUMBER OF ROWS AS MXORDER   */
   /*  OUTPUT:           */
   /*    VECTOR WITH PROBS CORRESPONDING TO VQUANT        */
   /*         FOR QUANT < SMALLEST ORDER STAT, RETURNS 1/(N+1)    */
   /*         FOR QUANT > LARGEST ORDER STAT, RETURNS N/(N+1)    */
   /*         OTHERWISE RETURNS WEIGHTED AVERAGE OF TWO CLOSEST    */

 LOCAL N,NGRID,VPROB,FLAGLO,SFLAGLO,VIND,FLAGHI,SFLAGHI,FLAGEQ,SFLAGEQ,
         FLAGEQS,VJS,VJE,FLAG,SFLAG,
VJ,VXORDER,VWT ;

 N = COLS(MXORDER) ;
 NGRID = ROWS(MXORDER) ;
 VPROB = ZEROS(NGRID,1) ;

 FLAGLO = VQUANT .< MXORDER[.,1] ;
 SFLAGLO = SUMC(FLAGLO) ;
 IF SFLAGLO > 0 ;
   VIND = SELIF(SEQA(1,1,NGRID),FLAGLO) ;
   VPROB[VIND] = (1 / (N+1)) * ONES(SFLAGLO,1) ;
 ENDIF ;

 FLAGHI = VQUANT .> MXORDER[.,N] ;
 SFLAGHI = SUMC(FLAGHI) ;
 IF SFLAGHI > 0 ;
   VIND = SELIF(SEQA(1,1,NGRID),FLAGHI) ;
   VPROB[VIND] = (N / (N+1)) * ONES(SFLAGHI,1) ;
 ENDIF ;

 FLAGEQ = (MXORDER .== VQUANT) ;
 FLAGEQS = SUMC(FLAGEQ') .> 0 ;      /*  ONE IN ROWS WHERE HAVE AN EQUAL  */
 SFLAGEQ = SUMC(FLAGEQS) ;
 IF SFLAGEQ > 0 ;
   VIND = SELIF(SEQA(1,1,NGRID),FLAGEQS) ;
   VJS = MAXINDC(FLAGEQ[VIND,.]') ;    /*  INDEX OF FIRST ONES  */
   VJE = N + 1 - MAXINDC(REV(FLAGEQ[VIND,.]')) ;    /*  INDEX OF LAST ONES  */
   VPROB[VIND] = (VJS + VJE) / (2 * (N + 1)) ;
 ENDIF ;

 FLAG = 1 - FLAGLO - FLAGHI - FLAGEQS ;
 SFLAG = NGRID - SFLAGLO - SFLAGHI - SFLAGEQ ;
 IF SFLAG > 0 ;
   VIND = SELIF(SEQA(1,1,NGRID),FLAG) ;
   VJ = MAXINDC((MXORDER[VIND,.] .> VQUANT[VIND])') ;
                               /*  INDEX OF FIRST X > QUANT  */
   VXORDER = ROTATER(MXORDER[VIND,.],2-VJ) ;
   VWT = (VQUANT[VIND] - VXORDER[.,1]) ;
   VWT = VWT ./ (VXORDER[.,2] - VXORDER[.,1]) ;
   VPROB[VIND] = ((1 - VWT) .* (VJ - 1)   + VWT .* VJ) / (N + 1) ;
 ENDIF ;

 RETP(VPROB) ;
ENDP ;
/* ============================ END PROC CPROB2 ======================= */

