/* =========================== START PROC CQUANT1 ======================= */
PROC CQUANT1(VXORDER,VALPHA) ;
   /*  THIS CALCULATES A CONTINUOUS VERSION OF QUANTILES,  */
   /*  BASED ON ONLY A SET OF ORDER STATISTICS FROM THE  */
   /*  GIVEN DISTRIBUTION     */
   /*  INPUTS:            */
   /*    VXORDER - VECTOR OF ORDER STATISTICS  */
   /*                  !!! assumed in increasing order   !!!   */
   /*    VALPHA  - VECTOR OF ALPHA'S                    */
   /*  OUPTUT:           */
   /*    VECTOR WITH QUANTILES CORRESPONDING TO EACH ALPHA        */
   /*         FOR ALPHA < 1/2(N+1),      RETURNS SMALLEST ORDER STAT    */
   /*         FOR ALPHA > (2N+1)/2(N+1), RETURNS BIGGEST ORDER STAT    */
   /*         OTHERWISE RETURNS AVERAGE OF TWO CLOSEST    */

 LOCAL N,NALPHA,FLAGLO,SFLAGLO,VIND,VQUANT,FLAGHI,SFLAGHI,FLAG,ANP1,VJ,WT ;

 N = ROWS(VXORDER) ;
 NALPHA = ROWS(VALPHA) ;
 VQUANT = ZEROS(NALPHA,1) ;

 FLAGLO = (VALPHA .< 1 / (N + 1)) ;
 SFLAGLO = SUMC(FLAGLO) ;
 IF SFLAGLO > 0 ;        /*  IF THERE ARE GUYS AT LOW END  */
   VIND = SELIF(SEQA(1,1,NALPHA),FLAGLO) ;
   VQUANT[VIND] = VXORDER[1] .* ONES(ROWS(VIND),1) ;
 ENDIF ;

 FLAGHI = (VALPHA .>= N / (N + 1)) ;
 SFLAGHI = SUMC(FLAGHI) ;
 IF SFLAGHI > 0 ;        /*  IF THERE ARE GUYS AT HIGH END   */
   VIND = SELIF(SEQA(1,1,NALPHA),FLAGHI) ;
   VQUANT[VIND] = VXORDER[N] .* ONES(ROWS(VIND),1) ;
 ENDIF ;

 IF SFLAGLO + SFLAGHI < NALPHA ;       /*  IF THERE ARE GUYS IN BETWEEN   */
   FLAG = 1 - FLAGLO - FLAGHI ;
   VIND = SELIF(SEQA(1,1,NALPHA),FLAG) ;
   ANP1 = VALPHA .* (N + 1) ;
   VJ = FLOOR(ANP1) ;
   WT = VJ + 1 - ANP1 ;
   VQUANT[VIND] = WT[VIND] .* VXORDER[VJ[VIND]]
                    + (1 - WT[VIND]) .* VXORDER[VJ[VIND]+1] ;
 ENDIF ;


 RETP(VQUANT) ;
ENDP ;
/* ============================ END PROC CQUANT ======================= */

