/* =========================== START PROC CQUANT2 ======================= */
PROC CQUANT2(MXORDER,ALPHA) ;
   /*  THIS CALCULATES A CONTINUOUS VERSION OF QUANTILES,   */
   /*  BASED ON ONLY A SET OF ORDER STATISTICS FROM THE    */
   /*  GIVEN DISTRIBUTION     */
   /*         THIS MODIFIES CQUANT1.G BY ALLOWING A MATRIX OF X VALUES  */
   /*         BUT ONLY ONE ALPHA   */
   /*  INPUTS:            */
   /*    MXORDER - MATRIX OF ORDER STATISTICS  */
   /*             !!! assumed in increasing order along rows   !!!   */
   /*    ALPHA  - QUANTILE TO BE FOUND FOR EACH ROW OF X'S          */
   /*  OUTPUT:           */
   /*    VECTOR WITH QUANTILES CORRESPONDING TO ALPHA        */
   /*         FOR ALPHA < 1/2(N+1),      RETURNS SMALLEST ORDER STAT    */
   /*         FOR ALPHA > (2N+1)/2(N+1), RETURNS BIGGEST ORDER STAT    */
   /*         OTHERWISE RETURNS AVERAGE OF TWO CLOSEST    */

 LOCAL N,NGRID,VQUANT,ANP1,J,WT ;

 N = COLS(MXORDER) ;
 NGRID = ROWS(MXORDER) ;
 VQUANT = ZEROS(NGRID,1) ;

 IF ALPHA .< 1 / (N + 1) ;
   VQUANT = MXORDER[.,1] ;
 ELSEIF ALPHA .>= N / (N + 1) ;
   VQUANT = MXORDER[.,N] ;
 ELSE ;
   ANP1 = ALPHA .* (N + 1) ;
   J = FLOOR(ANP1) ;
   WT = J + 1 - ANP1 ;
   VQUANT = WT .* MXORDER[.,J] + (1 - WT) .* MXORDER[.,J+1] ;
 ENDIF ;

 RETP(VQUANT) ;
ENDP ;
/* ============================ END PROC CQUANT ======================= */

