/*============================ START PROC EMECIG =========================*/
PROC EMECIG(VF,LAMBDA) ;
  /*  THIS FINDS ENDPOINT INDICES OF SUBINTERVALS FOR USE IN   */
  /*  THE CONTINUOUS EXCESS MASS STATISTIC  */
  /*  EACH SUBINTERVAL CORRESPONDS TO A CONNECTED SET, WHERE THE  */
  /*  FUNCTION F IS ABOVE THE THRESHOLD LAMBDA     */
  /*  INPUTS ARE:                       */
  /*      VF IS A VECTOR OF FUNCTION VALUES, A DISCRETIZATION  */
  /*              OF THE CONTINUOUS FUNCTION   */
  /*      LAMBDA IS THE THRESHOLD VALUE     */
  /*  OUTPUT IS A MATRIX, WHERE EACH ROW CORRESPONDS TO ONE SUBINTERVAL  */
  /*    WHERE COLUMNS ARE:                           */
  /*      VIS, VECTOR OF INDICES OF STARTING VALUES  */
  /*      VIE, VECTOR OF INDICES OF ENDING VALUES  */
  /*           BOTH ARE SET TO 0 IF F NEVER ABOVE LAMBDA   */

  LOCAL NF,FLAG,TFLAG,NTIND,SFLAG,IS,IE,VIS,VIE ;

  NF = ROWS(VF) ;

  FLAG = (VF .> LAMBDA) ;       /*  ONES WHERE BIGGER THAN LAMBDA  */
  TFLAG = FLAG ;      /*  VERSION FOR TRUNCATING  */
  NTIND = 0 ;       /*  NUMBER OF TRUNCATED INDICES  */


  SFLAG = 1 ;    /*  IN STARTING MODE  */
  VIE = 0 ;
  VIS = 0 ;
  DO WHILE SUMC(TFLAG) .> 0 ;
         /*  CONTINUE LOOP WHILE HAVE POINTS NOT GROUPED INTO INTERVALS  */

    IS = MAXINDC(TFLAG) + NTIND ;
        /*  FIRST INDEX WHERE F ABOVE LAMBDA IN FULL VECTORS */
    TFLAG = FLAG[IS:NF] ;
    NTIND = IS - 1 ;      /*   UPDATE NUMBER OF TRUNCATED INDICES   */
    IF SUMC(TFLAG) == ROWS(TFLAG) ;    /*  ALL ENTRIES ONES  */
      IE = NF ;
      TFLAG = 0 ;    /*  SO QUIT NOW  */
    ELSE ;                             /*  HAVE SOME ZEROS    */
      IE = MININDC(TFLAG) + NTIND - 1 ;
                         /*   INDEX BEFORE FIRST ZERO  */
      TFLAG = FLAG[IE+1:NF] ;
      NTIND = IE ;
    ENDIF ;

    IF SFLAG == 1 ;    /*  FIRST TIME THROUGH LOOP  */
      VIS = IS ;
      VIE = IE ;
      SFLAG = 0 ;
    ELSE ;             /*  ALREADY HAVE STARTED UP VECTORS  */
      VIS = VIS|IS ;
      VIE = VIE|IE ;
    ENDIF ;

  ENDO ;

  RETP(VIS~VIE) ;
ENDP ;
/*============================= END PROC EMECIG ==========================*/

