/*============================ START PROC EMED =========================*/
PROC EMED(DELX,VF,VLAMBDA,MAXK) ;
  /*  THIS FINDS ORDERED COMPONENTS E FOR    */
  /*  THE CONTINUOUS EXCESS MASS STATISTIC  */
  /*  INPUTS ARE:                       */
  /*      DELX IS THE BINWIDTH OF THE EQUALLY SPACED GRID     */
  /*              OF X VALUES, WHERE THE DENSITY IS EVALUATED  */
  /*      VF IS A VECTOR OF FUNCTION VALUES, A DISCRETIZATION  */
  /*              OF THE CONTINUOUS FUNCTION   */
  /*      MAXK IS THE LARGEST VALUE OF K (# MODES TESTED) TO CONSIDER  */
  /*      VLAMBDA IS A VECTOR OF THRESHOLD VALUES     */
  /*            (ASSUMED TO BE INCREASING)   */
  /*  OUTPUT IS A MATRIX, WHERE:   */
  /*           ROWS CORRESPOND TO LAMBDA VALUES   */
  /*           COLUMNS CORRESPOND TO K (NUMBER OF MODES TESTED)  */
  /*                                   = 1,...,MAXK   */

  LOCAL MD,IL,NL,VE,VD ;

  MD = ZEROS(ROWS(VLAMBDA),MAXK) ;

  IL = 1 ;
  NL = ROWS(VLAMBDA) ;
  DO WHILE  IL <= NL ;    /*  LOOP THROUGH LAMBDAS  */
    VE = CEME(DELX,VF,VLAMBDA[IL]) ;

    IF ROWS(VE) > 1 ;    /*  LOOKS MORE THAN UNIDMODAL FOR THIS LAM  */
      VD = REV(CUMSUMC(REV(VE))) ;
      VD = VD[2:ROWS(VD)] ;    /*  CUT OFF FIRST ONE  */
      IF ROWS(VD) >= MAXK ;
        MD[IL,.] = VD[1:MAXK]' ;
      ELSE ;
        MD[IL,1:ROWS(VD)] = VD' ;
      ENDIF ;
    ENDIF ;

    IL = IL + 1 ;
  ENDO ;

  RETP(MD) ;
ENDP ;
/*============================= END PROC EMED ==========================*/

