/* =========================== START PROC EMEHC3 ======================== */
PROC EMEHC3(BINCTS,LEFT,RIGHT,NXGRID,MAXK,LAM0,S0,EPS) ;
  /*  THIS FINDS EME BASED CRITICAL BANDWIDTHS  */
  /*  FOR NUMBER OF MODES BETWEEN K AND K+1,  K = 1,...,MAXK   */
  /*  FOR THE N(0,1) KERNEL DENSITY ESTIMATE     */
  /*  USING A BINNED IMPLEMENTATION      */
  /*  THIS IMPROVES EMEHC2 BY USING EMES3.G,   */
  /*  THE IMPROVED S STATISTIC, WHICH BETTER HANDLES MULTIPLE MODES   */
  /*  ALGORITHM STARTS WITH FINDING SILVERMAN'S HCRIT,1,  */
  /*  THEN STEPS DOWN BY FACTOR OF (1-EPS)   */
  /*  UNTIL THE S STATISTIC IS BIGGER THAN S0    */
  /*  INPUTS ARE:                      */
  /*      BINCTS - BINNED DATA (E.G. FROM BNLBD1.G)  */
  /*      LEFT - FIRST BIN CENTER    */
  /*      RIGHT - LAST BIN CENTER    */
  /*      NXGRID - THE NUMBER OF BINS  */
  /*      MAXK - THE LARGEST VALUE OF K (# MODES TESTED) TO CONSIDER  */
  /*      LAM0 - THE SMALLEST VALUE OF LAMBDA TO CONSIDER  */
  /*      S0 - THRESHOLD OF S STAT, BEFORE HAVE A "MODE"  */
  /*      EPS - FACTOR TO DECREASE BANDWIDTH FOR EACH STEP  */
  /*  OUTPUT IS:                      */
  /*      VHCRIT - VECTOR OF HCRITS, FOR K = 1,...,MAXK   */


  LOCAL VHCRIT,NOBS,K,HNEW,IKER,KPAR,VF,NM,DELX,S,HOLD,HACC,HBIG,HSMALL ;

  VHCRIT = ZEROS(MAXK,1) ;
  NOBS = SUMC(BINCTS) ;

  IKER = 1 ;
  KPAR = 2 ;
  DELX = (RIGHT - LEFT) / (NXGRID - 1) ;
  HACC = EPS / 2 ;

  K = 1 ;
  DO WHILE K <= MAXK ;

    HNEW = NMSDB(BINCTS,LEFT,RIGHT) * 3 / (70 * SQRT(PI) * NOBS)^(1/5) ;
            /*  OVERSMOOTHED BANDWIDTH  */
    VF= BNKED1(BINCTS,LEFT,RIGHT,HNEW,IKER,KPAR) ;
    VF = VF[.,1] ;
    NM = NMMCT(VF) ;

                  /*  FIRST GET HOLD AND HNEW TO BRACKET HCRITK  */
    IF NM > K ;           /*  IF H TO LEFT OF HCRITK  */
      DO WHILE NM > K ;   /*  ITERATE UNTIL HAVE H TO RIGHT OF HCRITK  */
        HOLD = HNEW ;
        HNEW = 2 * HOLD ;
        VF = BNKED1(BINCTS,LEFT,RIGHT,HNEW,IKER,KPAR) ;
        VF = VF[.,1] ;
        NM = NMMCT(VF) ;
      ENDO ;
    ELSE ;                      /*  IF H LARGER THAN HCRIT  */
      DO WHILE NM <= K ;   /*  ITERATE UNTIL HAVE H TO LEFT OF HCRITK  */
        HOLD = HNEW ;
        HNEW = HOLD / 2 ;
        VF = BNKED1(BINCTS,LEFT,RIGHT,HNEW,IKER,KPAR) ;
        VF = VF[.,1] ;
        NM = NMMCT(VF) ;
      ENDO ;
    ENDIF ;

                    /*   NOW CLOSE IN ON HCRITK  */
    HBIG = MAXC(HOLD|HNEW) ;
    HSMALL = MINC(HOLD|HNEW) ;
    DO WHILE (HBIG / HSMALL) > 1 + HACC ;  /*  ITERATE TO DESIRED ACCURACY  */
      HNEW = SQRT(HBIG * HSMALL) ;   /*  GEOMETRIC MEAN  */
      VF = BNKED1(BINCTS,LEFT,RIGHT,HNEW,IKER,KPAR) ;
      VF = VF[.,1] ;
      NM = NMMCT(VF) ;
      IF NM > K ;           /*  IF HNEW TO LEFT OF HCRITK  */
        HSMALL = HNEW ;
      ELSE ;
        HBIG = HNEW ;
      ENDIF ;
    ENDO ;

                   /*  NOW WORK WITH S STATISTIC  */
    S = EMES3(DELX,VF,LAM0,MAXK) ;
    S = S[K] ;

    DO UNTIL S > S0 ;
      HNEW = HNEW * (1 - EPS) ;
      VF = BNKED1(BINCTS,LEFT,RIGHT,HNEW,IKER,KPAR) ;
      VF = VF[.,1] ;
      S = EMES3(DELX,VF,LAM0,MAXK) ;
      S = S[K] ;
    ENDO ;

    VHCRIT[K] = HNEW ;
    K = K + 1 ;

  ENDO ;


  RETP(VHCRIT) ;
ENDP ;
/* ============================ END PROC EMEHC3 ======================== */

