/* =========================== START PROC EMEHC5 ======================== */
PROC EMEHC5(BINCTS,LEFT,RIGHT,NXGRID,MAXK,LAM0,M0,EPS,EPSJUMP) ;
  /*  THIS FINDS EME BASED CRITICAL BANDWIDTHS  */
  /*  FOR NUMBER OF MODES BETWEEN K AND K+1,  K = 1,...,MAXK   */
  /*  FOR THE N(0,1) KERNEL DENSITY ESTIMATE     */
  /*  USING A BINNED IMPLEMENTATION      */
  /*  THIS IMPROVES EMEHC4 BY AVOIDING SO MANY STEPS   */
  /*  THE IMPROVED S STATISTIC, WHICH BETTER HANDLES MULTIPLE MODES   */
  /*  BY COMBINING MODES WHEN E < M0    */
  /*  ALGORITHM STARTS WITH FINDING SILVERMAN'S HCRIT,1,  */
  /*  THEN STEPS DOWN BY FACTOR OF (1-EPSJUMP)   */
  /*  UNTIL THE S STATISTIC IS POSITIVE    */
  /*  THEN CLOSES IN UNTIL DIFFERENCE IS < EPS  */
  /*  INPUTS ARE:                      */
  /*      BINCTS - BINNED DATA (E.G. FROM BNLBD1.G)  */
  /*      LEFT - FIRST BIN CENTER    */
  /*      RIGHT - LAST BIN CENTER    */
  /*      NXGRID - THE NUMBER OF BINS  */
  /*      MAXK - THE LARGEST VALUE OF K (# MODES TESTED) TO CONSIDER  */
  /*      LAM0 - THE SMALLEST VALUE OF LAMBDA TO CONSIDER  */
  /*      M0 - THRESHOLD BELOW WHICH "MODES" ARE COMBINED   */
  /*      EPS - FINAL ACCURACY  */
  /*      EPSJUMP - FACTOR TO DECREASE BANDWIDTH FOR EACH STEP  */
  /*                  .02 IS CONSIDERED "SAFE BUT SLOW"  */
  /*                  .1  IS FASTER, BUT COULD MISS LOCAL ROOTS  */
  /*  OUTPUT IS:                      */
  /*      VHCRIT - VECTOR OF HCRITS, FOR K = 1,...,MAXK   */


  LOCAL VHCRIT,NOBS,K,HNEW,IKER,KPAR,VF,NM,DELX,S,HOLD,HACC,HBIG,HSMALL ;

  VHCRIT = ZEROS(MAXK,1) ;
  NOBS = SUMC(BINCTS) ;

  IKER = 1 ;
  KPAR = 2 ;
  DELX = (RIGHT - LEFT) / (NXGRID - 1) ;
  HACC = EPS / 2 ;

  K = 1 ;
  DO WHILE K <= MAXK ;

    HNEW = NMSDB(BINCTS,LEFT,RIGHT) * 3 / (70 * SQRT(PI) * NOBS)^(1/5) ;
            /*  OVERSMOOTHED BANDWIDTH  */
    VF= BNKED1(BINCTS,LEFT,RIGHT,HNEW,IKER,KPAR) ;
    VF = VF[.,1] ;
    NM = NMMCT(VF) ;

                  /*  FIRST GET HOLD AND HNEW TO BRACKET HCRITK  */
    IF NM > K ;           /*  IF H TO LEFT OF HCRITK  */
      DO WHILE NM > K ;   /*  ITERATE UNTIL HAVE H TO RIGHT OF HCRITK  */
        HOLD = HNEW ;
        HNEW = 2 * HOLD ;
        VF = BNKED1(BINCTS,LEFT,RIGHT,HNEW,IKER,KPAR) ;
        VF = VF[.,1] ;
        NM = NMMCT(VF) ;
      ENDO ;
    ELSE ;                      /*  IF H LARGER THAN HCRIT  */
      DO WHILE NM <= K ;   /*  ITERATE UNTIL HAVE H TO LEFT OF HCRITK  */
        HOLD = HNEW ;
        HNEW = HOLD / 2 ;
        VF = BNKED1(BINCTS,LEFT,RIGHT,HNEW,IKER,KPAR) ;
        VF = VF[.,1] ;
        NM = NMMCT(VF) ;
      ENDO ;
    ENDIF ;

                    /*   NOW CLOSE IN ON HCRITK  */
    HBIG = MAXC(HOLD|HNEW) ;
    HSMALL = MINC(HOLD|HNEW) ;
    DO WHILE (HBIG / HSMALL) > 1 + HACC ;  /*  ITERATE TO DESIRED ACCURACY  */
      HNEW = SQRT(HBIG * HSMALL) ;   /*  GEOMETRIC MEAN  */
      VF = BNKED1(BINCTS,LEFT,RIGHT,HNEW,IKER,KPAR) ;
      VF = VF[.,1] ;
      NM = NMMCT(VF) ;
      IF NM > K ;           /*  IF HNEW TO LEFT OF HCRITK  */
        HSMALL = HNEW ;
      ELSE ;
        HBIG = HNEW ;
      ENDIF ;
    ENDO ;

                   /*  NOW WORK WITH S STATISTIC  */
    S = EMES4(DELX,VF,LAM0,M0,MAXK) ;
    S = S[K] ;

    IF S <= 0 ;   /*  NEED TO STEP DOWN  */

                    /*  FIRST TAKE CRUDE STEPS  */
      HSMALL = HNEW ;
      DO UNTIL S > 0 ;
        HBIG = HSMALL ;
        HSMALL = HBIG * (1 - EPSJUMP) ;
        VF = BNKED1(BINCTS,LEFT,RIGHT,HSMALL,IKER,KPAR) ;
        VF = VF[.,1] ;
        S = EMES4(DELX,VF,LAM0,M0,MAXK) ;
        S = S[K] ;
      ENDO ;

                    /*   NOW CLOSE IN ON HCRITK  */
      DO WHILE (HBIG / HSMALL) > 1 + HACC ;  /* ITERATE TO DESIRED ACCURACY */
        HNEW = SQRT(HBIG * HSMALL) ;   /*  GEOMETRIC MEAN  */
        VF = BNKED1(BINCTS,LEFT,RIGHT,HNEW,IKER,KPAR) ;
        VF = VF[.,1] ;
        S = EMES4(DELX,VF,LAM0,M0,MAXK) ;
        S = S[K] ;
        IF S > 0 ;           /*  IF HNEW TO LEFT OF HCRITK  */
          HSMALL = HNEW ;
        ELSE ;
          HBIG = HNEW ;
        ENDIF ;
      ENDO ;

    ENDIF ;

    VHCRIT[K] = HNEW ;
    K = K + 1 ;

  ENDO ;


  RETP(VHCRIT) ;
ENDP ;
/* ============================ END PROC EMEHC5 ======================== */
