/*============================ START PROC EMES =========================*/
PROC EMES(DELX,VF,LAM0,NLAM,MAXK) ;
  /*  THIS FINDS THE STATISTIC S FOR    */
  /*  THE CONTINUOUS EXCESS MASS STATISTIC  */
  /*  THIS USES ITS OWN GRID OF LAMBDA'S,     */
  /*  FROM LAMBDA0 TO THE MAX OF THE X VECTOR  */
  /*  INPUTS ARE:                       */
  /*      DELX IS THE BINWIDTH OF THE EQUALLY SPACED GRID     */
  /*              OF X VALUES, WHERE THE DENSITY IS EVALUATED  */
  /*      VF IS A VECTOR OF FUNCTION VALUES, A DISCRETIZATION  */
  /*              OF THE CONTINUOUS FUNCTION   */
  /*      LAM0 IS THE SMALLEST VALUE OF LAMBDA TO CONSIDER  */
  /*      NLAM IS THE NUMBER OF LAMBDAS IN THE GRID TO USE  */
  /*      MAXK IS THE LARGEST VALUE OF K (# MODES TESTED) TO CONSIDER  */
  /*  OUTPUT IS A VECTOR, WHERE:   */
  /*           ROWS CORRESPOND TO K (NUMBER OF MODES TESTED)  */
  /*                                   = 1,...,MAXK   */

  LOCAL MAXF,VS,DELLAM,VLAM,MD ;

  MAXF = MAXC(VF) ;

  IF LAM0 > MAXF ;
    VS = ZEROS(MAXK,1) ;
  ELSE ;
    DELLAM = (MAXC(VF) - LAM0) / NLAM ;
    VLAM = SEQA(LAM0,DELLAM,NLAM) ;

    MD = EMED(DELX,VF,VLAM,MAXK) ;

    VS = MAXC(MD) ;
  ENDIF ;


  RETP(VS) ;
ENDP ;
/*============================= END PROC EMES ==========================*/

