/*============================ START PROC EMES2 =========================*/
PROC EMES2(DELX,VF,LAM0,MAXK) ;
  /*  THIS FINDS THE STATISTIC S FOR    */
  /*  THE CONTINUOUS EXCESS MASS STATISTIC  */
  /*  THIS IMPROVES EMES.G, BY USING A BETTER GRID OF LAMBDA'S  */
  /*  THIS GRID OF LAMBDA'S, ARE THE LOCAL MINIMIZER'S OF F     */
  /*  THAT ARE >= LAMBDA0  */
  /*  INPUTS ARE:                       */
  /*      DELX IS THE BINWIDTH OF THE EQUALLY SPACED GRID     */
  /*              OF X VALUES, WHERE THE DENSITY IS EVALUATED  */
  /*      VF IS A VECTOR OF FUNCTION VALUES, A DISCRETIZATION  */
  /*              OF THE CONTINUOUS FUNCTION   */
  /*      LAM0 IS THE SMALLEST VALUE OF LAMBDA TO CONSIDER  */
  /*      MAXK IS THE LARGEST VALUE OF K (# MODES TESTED) TO CONSIDER  */
  /*  OUTPUT IS A VECTOR, WHERE:   */
  /*           ROWS CORRESPOND TO K (NUMBER OF MODES TESTED)  */
  /*                                   = 1,...,MAXK   */

  LOCAL NG,VFD,FLAGMIN,VLAM,VS,MD ;

  NG = ROWS(VF) ;

  VFD = VF[2:NG] - VF[1:NG-1] ;    /*  VECTOR OF DIFFERENCES   */
  VFD = (VFD .> 0) - (VFD .< 0) ;    /*    1 WHERE "GOING UP"
                                           0 WHERE "CONSTANT"
                                          -1 WHERE "GOING DOWN"   */

  FLAGMIN = VFD[2:NG-1] - VFD[1:NG-2] ;   /*  POSITIVE AT LOCAL MINS  */
  FLAGMIN = (FLAGMIN .> 0) ;       /*    1 AT LOCAL MINS    */

  FLAGMIN = FLAGMIN .* (VF[2:NG-1] .>= LAM0) ;    /*  0 OUT SMALL ONES  */

  IF SUMC(FLAGMIN .> 0) ;     /*  IF HAVE SOME LOCAL MINIMA   */
    VLAM = SELIF(VF[2:NG-1],FLAGMIN) ;
    VLAM = VLAM|LAM0 ;
  ELSE ;
    VLAM = LAM0 ;
  ENDIF ;

  MD = EMED(DELX,VF,VLAM,MAXK) ;

  VS = MAXC(MD) ;

  RETP(VS) ;
ENDP ;
/*============================= END PROC EMES2 ==========================*/

