/*============================ START PROC EMES3 =========================*/
PROC EMES3(DELX,VF,LAM0,MAXK) ;
  /*  THIS FINDS THE STATISTIC S FOR    */
  /*  THE 2ND GENERATION CONTINUOUS EXCESS MASS STATISTIC  */
  /*  THIS IMPROVES EMES2.G, BY ADDRESSING THE PROBLEMS  */
  /*  FOR MORE THAN ONE MODE, BY USING AN INDIVIDUAL  */
  /*  LAMBDA TAILORED TO EACH MODE, BUT STILL >= LAMBDA0  */
  /*  INPUTS ARE:                       */
  /*      DELX IS THE BINWIDTH OF THE EQUALLY SPACED GRID     */
  /*              OF X VALUES, WHERE THE DENSITY IS EVALUATED  */
  /*      VF IS A VECTOR OF FUNCTION VALUES, A DISCRETIZATION  */
  /*              OF THE CONTINUOUS FUNCTION   */
  /*      LAM0 IS THE SMALLEST VALUE OF LAMBDA TO CONSIDER  */
  /*      MAXK IS THE LARGEST VALUE OF K (# MODES TESTED) TO CONSIDER  */
  /*  OUTPUT IS A VECTOR, WHERE:   */
  /*           ROWS CORRESPOND TO K (NUMBER OF MODES TESTED)  */
  /*                                   = 1,...,MAXK   */

  LOCAL NG,VS,VFD,NGT,FLAG,INDXMIN,INDXMAX,NMAX,MINDX,VLAM,VE,IMAX,
       VIND,INDA,INDB,VFML ;

  NG = ROWS(VF) ;
  VS = ZEROS(MAXK,1) ;

  VFD = VF[2:NG] - VF[1:NG-1] ;    /*  VECTOR OF DIFFERENCES   */
  VFD = (VFD .> 0) - (VFD .< 0) ;    /*    1 WHERE "GOING UP"
                                           0 WHERE "CONSTANT"
                                          -1 WHERE "GOING DOWN"   */

  VFD = SELIF(VFD~SEQA(1,1,NG-1), (VFD ./= 0) ) ;
                /*  SQUEEZE OUT "FLAT BITS", BUT REMEMBER INDICES  */
  NGT = ROWS(VFD) ;

  FLAG = VFD[2:NGT,1] - VFD[1:NGT-1,1] ;
                                    /*  POSITIVE AT LOCAL MIN'S  */
                                    /*  NEGATIVE AT LOCAL MAX'S  */

  IF SUMC(FLAG .> 0) > 0 ;
    INDXMIN = SELIF(VFD[2:NGT,2], (FLAG .> 0)) ;
                                    /*  INDICES OF LOCAL MINIMIZERS   */
  ELSE ;
    INDXMIN = 1|NG ;
  ENDIF ;

  IF SUMC(FLAG .< 0) > 0 ;
    INDXMAX = SELIF(VFD[2:NGT,2], (FLAG .< 0)) ;
                                      /*  INDICES OF LOCAL MAXIMIZERS   */

    IF INDXMAX[1] < INDXMIN[1] ;            /* FIRST MAX BEFORE FIRST MIN  */
      INDXMIN = 1|INDXMIN ;
    ENDIF ;
    NMAX = ROWS(INDXMAX) ;
    IF INDXMAX[NMAX] > INDXMIN[ROWS(INDXMIN)] ; /* LAST MAX AFTER LAST MIN  */
      INDXMIN = INDXMIN|NG ;
    ENDIF ;

    MINDX = INDXMIN[1:NMAX]~INDXMAX~INDXMIN[2:NMAX+1] ;
         /*  MATRIX OF INDICES OF MAXES SURROUNDED BY SUCCESSIVE MIN'S   */

    FLAG = VF[MINDX[.,2]] .> LAM0 ;
    IF SUMC(FLAG) > 0 ;
      MINDX = SELIF(MINDX,FLAG) ;
              /*  KICK OUT MODES NOT ABOVE LEVEL LAM0   */
      NMAX = ROWS(MINDX) ;

      VE = ZEROS(NMAX,1) ;
      IF NMAX > 1 ;    /*  LOOKS MORE THAN UNIDMODAL FOR THIS LAM  */

        VLAM = MAXC((VF[MINDX[.,1]]~VF[MINDX[.,3]]~(LAM0 * ONES(NMAX,1)))') ;

        IMAX = 1 ;
        DO WHILE IMAX <= NMAX ;           /*  LOOP THROUGH LOCAL MAXES  */

          /*  GET INDEX OF A, START OF INTEGRAL  */
          VIND = SEQA(MINDX[IMAX,1],1,MINDX[IMAX,2]-MINDX[IMAX,1]+1) ;
                           /*  SET OF INDICES FROM LEFT LOCAL MIN TO MAX  */
          FLAG = VF[VIND] .> VLAM[IMAX] ;
                           /*  ONE WHERE F ABOVE LAMBDA THRESHOLD  */
          INDA = VIND[MAXINDC(FLAG)] ;
                           /*  INDEX AT FIRST POINT F ABOVE THRESHOLD  */

          /*  GET INDEX OF B, END OF INTEGRAL  */
          VIND = SEQA(MINDX[IMAX,2],1,MINDX[IMAX,3]-MINDX[IMAX,2]+1) ;
                           /*  SET OF INDICES FROM MAX TO RIGHT LOCAL MIN  */
          FLAG = VF[VIND] .> VLAM[IMAX] ;
                           /*  ONE WHERE F ABOVE LAMBDA THRESHOLD  */
          INDB = VIND[MININDC(FLAG)] - 1 ;
                           /*  INDEX AT LAST POINT F ABOVE THRESHOLD  */


          VFML = VF[INDA:INDB] - VLAM[IMAX] ;       /*  VECTOR TO INTEGRATE  */
          VE[IMAX] = DELX * SUMC(VFML) ;            /*  NUMERICAL INTEGRAL   */

          IMAX = IMAX + 1 ;
        ENDO ;

        VE = SORTC(VE,1) ;        /*  SMALLEST FIRST   */
        VE = CUMSUMC(VE) ;      /*  BIGGEST ONLY IN LAST SUM  */
        VE = REV(VE) ;      /*  BIGGEST ONES FIRST  */

        VE = VE[2:ROWS(VE)] ;    /*  CUT OFF FIRST ONE  */
        IF ROWS(VE) >= MAXK ;
          VS = VE[1:MAXK] ;
        ELSE ;
          VS[1:ROWS(VE)] = VE ;
        ENDIF ;

      ENDIF ;

    ENDIF ;

  ENDIF ;


  RETP(VS) ;
ENDP ;
/*============================= END PROC EMES3 ==========================*/

