/*========================== START PROC GEEST1 ============================*/
PROC (1) = GEEST1(X,Y,BW) ;
  /*  THIS IS FOR THE GEOLOGY STUDY     */
  /*  DOES A WEIGHTED LEAST SQUARES FIT OF A PARABOLA,   */
  /*  OF THE FORM  P(X) = B0 + B2*X^2  */
  /*  TO THE X AND Y DATA, USING A UNIFORM WINDOW,   */
  /*  OVER THE INTERVAL  [0,BANDWIDTH]  */
  /*  RETURN IS THE ESTIMATED VALUE OF THE INTERCEPT, B0   */

  LOCAL WTS,S0,S2,S4,T0,T2,BHAT ;

  WTS = (XOBS .>= 0) ;                    /*  1 WHERE X'S >= 0  */
  WTS = WTS .* (XOBS .<= BW) ;            /*  AND WHERE <= BW  */

  S0 = SUMC(WTS) ;
  S2 = SUMC(WTS .* X^2) ;
  S4 = SUMC(WTS .* X^4) ;
  T0 = SUMC(WTS .* Y) ;
  T2 = SUMC(WTS .* Y .* X^2) ;
  BHAT = (S4 * T0 - S2 * T2) ;
  BHAT = BHAT ./ (S0 * S4 - S2 * S2) ;

  RETP(BHAT) ;
ENDP ;
/*=========================== END PROC GEEST1 =============================*/
