/*========================== START PROC GEEST2 ============================*/
PROC (1) = GEEST2(X,Y,ALPHA,TRIMP) ;
  /*  THIS IS FOR THE GEOLOGY STUDY     */
  /*  DOES A SERIES OF WEIGHTED LEAST SQUARES FITS OF A PARABOLA,   */
  /*  OF THE FORM  P(X) = B0 + B2*X^2  */
  /*  TO THE X AND Y DATA, USING UNIFORM WINDOWS,   */
  /*  OVER A SERIES OF INTERVALS OF THE FORM [0,X(.)]  */
  /*  ASSUMES X IS ORDERED, AND EACH ENTRY NONNEGATIVE  */
  /*  THEN FINDS A "LEFT END OF ACCEPTABILITY"  */
  /*      WHICH IS LAST TIME p-VALUE FOR SIG OF B2 /= 0  */
  /*      CROSSES BELOW ALPHA (SUGGEST ALPHA BETWEEN .05 AND .01)  */
  /*  THEN FINDS A "RIGHT END OF ACCEPTABILITY"  */
  /*      WHICH IS LAST TIME p-VALUE FOR SIG OF A CUBIC TERM  */
  /*      CROSSES BELOW ALPHA (SUGGEST ALPHA BETWEEN .05 AND .01)  */
  /*  RETURNS AVERAGE OF B0 ESTIMATES OVER THE RANGE  */
  /*      [LEFT END, TRIMP*(RIGHT END)]  */
  /*                           (SUGGEST TRIMP BETWEEN .5 AND .2)  */
  /*  TOGETHER WITH "INDEX OF THE LEFT ENDPOINT OF ACCEPTABILITY"  */
  /*        AND THE "INDEX OF THE RIGHT ENDPOINT OF ACCEPTABILITY"  */

  LOCAL NOBS,VX0,VX2,VX3,VX4,VX5,VX6,V2S0,V2S2,V2S4,V2T0,V2T2,V2DET,V2A,V2C,
         VNY,PV,PV0,VSIG2,VF,VPVAL,FLAG,ILEA,NLEA,NREA,IREA,
         I3S,N3S,V3S0,V3S2,V3S3,V3S4,V3S5,V3S6,V3T0,V3T2,V3T3,
         V3DET,V3NY,P3V,PV3,V3F,V3PVAL,BHAT ;

  NOBS = ROWS(X) ;

                /*  VECTORS WITH POWERS OF X  */
  VX0 = ONES(NOBS,1) ;
  VX2 = X .* X ;
  VX3 = VX2 .* X ;
  VX4 = VX3 .* X ;
  VX5 = VX4 .* X ;
  VX6 = VX5 .* X ;

                /*  CALCULATE SUMS FOR PARABOLA  */
  V2S0 = CUMSUMC(VX0) ;
  V2S0 = V2S0[3:NOBS] ;
  V2S2 = CUMSUMC(VX2) ;
  V2S2 = V2S2[3:NOBS] ;
  V2S4 = CUMSUMC(VX4) ;
  V2S4 = V2S4[3:NOBS] ;
  V2T0 = CUMSUMC(Y) ;
  V2T0 = V2T0[3:NOBS] ;
  V2T2 = CUMSUMC(VX2 .* Y) ;
  V2T2 = V2T2[3:NOBS] ;

                /*  CALCULATE SEQUENCE OF PARABOLIC FITS  */
  V2DET = V2S0 .* V2S4 - V2S2^2 ;
  V2A = (V2S4 .* V2T0 - V2S2 .* V2T2) ./ V2DET ;
  V2C = (V2S0 .* V2T2 - V2S2 .* V2T0) ./ V2DET ;

                /*  CALCULATE P VALUES FOR PARABOLIC FITS  */
  VNY = CUMSUMC(Y^2) ;
  VNY = VNY[3:NOBS,.] ;
  PV = V2S0 .* V2A .* V2A  +  2 * V2S2 .* V2A .* V2C  +  V2S4 .* V2C .* V2C ;
  PV0 = V2T0^2 ./ V2S0 ;
  VSIG2 = (VNY - PV) ./ (V2S0 - 2) ;
  VF = (PV - PV0) ./ VSIG2 ;
  VF = ABS(VF) ;
  VPVAL = CDFFC(VF,ONES(NOBS-2,1),V2S0-2) ;


                /*  FIND INDEX OF LEFT END OF ACCEPTABILITY  */
    FLAG = (VPVAL .> ALPHA) ;       /*  0 WHERE p-VAL < ALPHA  */
  IF SUMC(FLAG) == 0 ;    /*  ALL p-VALS < ALPHA  */
    ILEA = 1 ;
  ELSE ;
    ILEA = MAXINDC(REV(FLAG)) ;     /*  INDEX WHERE REV(FLAG) FIRST NOT 0 */
    IF ILEA == 1 ;
      ILEA = ROWS(FLAG) ;
    ELSE ;
      ILEA = ROWS(FLAG) - ILEA + 2 ; /*  INDEX AFTER FLAG LAST NOT 0  */
                                     /*  OF FORM   ((N + 1) - I) + 1  */
    ENDIF ;
  ENDIF ;
  NLEA = ILEA + 2 ;     /*  INDEX ON SCALE OF ORIGINAL VECTOR OF DATA,
                                NOT SUBECTOR WHERE PARABOLAS ARE FIT */


  IF NLEA == NOBS ;    /*  PARABOLA NEVER SIGNIFICANT  */
    NREA = NLEA ;              /*  SET RIGHT END OF ACCEPTABILITY TO SAME  */
    IREA = ILEA ;

    "**************************************************************" ;
    "***                                                        ***" ;
    "***    WARNING: Test Shows Should Use Entire Data Range    ***" ;
    "***                 Estimate Is Based Only On This         ***" ;
    "***                                                        ***" ;
    "**************************************************************" ; ? ;

  ELSE ;                  /*  FIND RIGHT END BY CUBIC FIT   */

                  /*  CALCULATE SUMS FOR CUBIC  */
    I3S = MAXC(2|ILEA) ;          /*  ON SCALE OF PARABOLA FIT VECTOR  */
    N3S = I3S + 2 ;               /*  ON SCALE OF OBSERVATION VECTORS  */
    V3S0 = V2S0[I3S:NOBS-2] ;
    V3S2 = V2S2[I3S:NOBS-2] ;
    V3S3 = CUMSUMC(VX3) ;
    V3S3 = V3S3[N3S:NOBS] ;
    V3S4 = V2S4[I3S:NOBS-2] ;
    V3S5 = CUMSUMC(VX5) ;
    V3S5 = V3S5[N3S:NOBS] ;
    V3S6 = CUMSUMC(VX6) ;
    V3S6 = V3S6[N3S:NOBS] ;
    V3T0 = V2T0[I3S:NOBS-2] ;
    V3T2 = V2T2[I3S:NOBS-2] ;
    V3T3 = CUMSUMC(VX3 .* Y) ;
    V3T3 = V3T3[N3S:NOBS] ;

                /*  CALCULATE SEQUENCE OF PARABOLIC FITS AND P VALUES */
    V3DET = V3S0 .* V3S4 .* V3S6 + 2 * V3S2 .* V3S3 .* V3S5 - V3S3^2 .* V3S4 ;
    V3DET = V3DET - V3S0 .* V3S5^2 - V3S2^2 .* V3S6 ;
    V3NY = VNY[I3S:NOBS-2,.] ;
    P3V = PV[I3S:NOBS-2,.] ;
    PV3 = V3T0^2 .* (V3S4 .* V3S6 - V3S5^2) ;
    PV3 = PV3 + 2 * V3T0 .* V3T2 .* (V3S3 .* V3S5 - V3S2 .* V3S6) ;
    PV3 = PV3 + 2 * V3T0 .* V3T3 .* (V3S2 .* V3S5 - V3S3 .* V3S4) ;
    PV3 = PV3 + V3T2^2 .* (V3S0 .* V3S6 - V3S3^2) ;
    PV3 = PV3 + 2 * V3T2 .* V3T3 .* (V3S2 .* V3S3 - V3S0 .* V3S5) ;
    PV3 = PV3 + V3T3^2 .* (V3S0 .* V3S4 - V3S2^2) ;
    PV3 = PV3 ./ V3DET ;
    V3F = (PV3 - P3V) ./ ((V3NY - PV3) ./ (V3S0 - 3)) ;
    V3F = ABS(V3F) ;
    V3PVAL = CDFFC(V3F,ONES(NOBS-N3S+1,1),V3S0-3) ;


                  /*  FIND INDEX OF RIGHT END OF ACCEPTABILITY  */
      FLAG = (V3PVAL .> ALPHA) ;       /*  0 WHERE p-VAL < ALPHA  */
    IF SUMC(FLAG) == 0 ;    /*  ALL p-VALS < ALPHA  */
      IREA = ILEA ;
    ELSE ;
      IREA = MAXINDC(REV(FLAG)) ;   /*  INDEX WHERE REV(FLAG) FIRST NOT 0 */
      IREA = NOBS - IREA - 1 ;      /*  OF FORM   ((NOBS - 2) - (IREA - 1)  */
    ENDIF ;
    NREA = IREA + 2 ;     /*  INDEX ON SCALE OF ORIGINAL VECTOR OF DATA,
                                  NOT SUBECTOR WHERE PARABOLAS ARE FIT */


                     /*  CUT OFF SOME ON RIGHT END TO ACCOUNT FOR BIAS  */
    IREA = ROUND(IREA - TRIMP * (IREA - ILEA)) ;
    FLAG = IREA - ILEA + 1 ;
    IF FLAG <= 5 ;
      FORMAT /RD 1,0 ;
      "************************************************" ;
      "**  CAUTION:  Estimate Only Using " FLAG "Value(s)  **" ;
      "************************************************" ; ? ;
    ENDIF ;

  ENDIF ;

  BHAT = MEANC(V2A[ILEA:IREA]) ;

  RETP(BHAT|ILEA|IREA) ;
ENDP ;
/*=========================== END PROC GEEST2 =============================*/
