/* =========================== START PROC GPKED1 ======================== */
PROC GPKED1(DATA,LEFT,RIGHT,NXGRID,H,IKER,KPAR) ;
   /*  DIRECT MATRIX CALCULATION OF A KERNEL ESTIMATE OF A DENSITY  */
   /*  ALGORITHM HERE IS A LOOP THROUGH THE DATA POINTS  */
   /*     caution: SHOULD USED BINNED VERSION BNKED1.G FOR SPEED  */
   /*  ON AN EQUALLY SPACED GRID OF NXGRID POINTS,   */
   /*      EQUALLY SPACED FROM LEFT TO RIGHT  */
   /*  H IS THE BANDWIDTH, MUST BE A SCALAR    */
   /*  IKER = 1  -  GAUSSIAN HIGHER ORDER FAMILY    */
   /*            KPAR = 2  -  STANDARD NORMAL   */
   /*            KPAR = 4  -  GRAM CHARLIER, ORDER 4   */
   /*            KPAR = 6  -  GRAM CHARLIER, ORDER 6   */
   /*  IKER = 2  -  BETA, SUPPORTED [-1,1], WITH  */
   /*            KPAR = 0  -  UNIFORM   */
   /*            KPAR = 1  -  EPANECHNIKOV   */
   /*            KPAR = 2  -  BIWEIGHT   */
   /*            KPAR = 3  -  TRIWEIGHT   */
   /*  OUTPUT IS A MATRIX,       */
   /*  FIRST COLUMN IS HEIGHTS OF THE ESTIMATE, AT BIN CENTERS  */
   /*  SECOND COLUMN IS THE KERNEL FUNCTION USED   */
   /*  CAUTION, KERNEL ONLY GIVES SHAPE AND WILL NEED RESCALING  */

 LOCAL NOBS,XGRID,R,CS,MDATA,MH,VIS,VIE,IOBS,FHAT,ARG,NARG,HP,HPN,IS,KVEC,IE ;

 NOBS = ROWS(DATA) ;

 XGRID = SEQA(LEFT,(RIGHT - LEFT) / (NXGRID - 1),NXGRID) ;

 IF IKER == 1 ;
   R = KPAR / 2 ;                           /*  CONVENIENT FOR HERMITES  */
   CS = SEQM(1,-.5,R) ./ SEQA(0,1,R)! ;     /*  COEFFS FOR HERMITES  */
 ELSEIF IKER == 2 ;
   MDATA = ((NXGRID - 1) * (DATA - LEFT) / (RIGHT - LEFT)) + 1 ;
                  /*  MAP DATA IN [LEFT,RIGHT] TO INTERVAL [1, NXGRID]  */
   MH = ((NXGRID - 1) * H / (RIGHT - LEFT)) ;
                  /*  MAP H ON [LEFT,RIGHT] TO INTERVAL [1, NXGRID]  */
   VIS = CEIL(MDATA - MH) ;      /*  VECTOR OF STARTING POINTS  */
   VIS = MAXC(VIS'|ONES(1,NOBS)) ;
   VIE = FLOOR(MDATA + MH) ;      /*  VECTOR OF ENDING POINTS  */
   VIE = MINC(VIE'|(NXGRID*ONES(1,NOBS))) ;
     MDATA = 0 ;          /*  TO SAVE SPACE  */
 ENDIF ;


 IOBS = 1 ;
 FHAT = ZEROS(NXGRID,1) ;
 DO WHILE IOBS <= NOBS ;
   "." ;;

   IF IKER == 1 ;
     ARG = (XGRID - DATA[IOBS]) / H ;

     NARG = PDFN(ARG) ;

     IF KPAR > 2 ;
       HP = ONES(ROWS(ARG),COLS(ARG)) ;       /*  0TH HERMITE POLY  */
       HPN = ARG ;                         /*  1ST HERMITE POLY  */
       KVEC = HP .* NARG ;
       IS = 1 ;
       DO WHILE IS <= (R - 1) ;
         HP = ARG .* HPN - (2*IS - 1) * HP ;   /* (2*IS)-TH HERMITE POLY  */
         HPN = ARG .* HP - (2*IS) * HPN ;   /*  (2*IS+1)-TH HERMITE POLY  */
         KVEC = KVEC~(HP .* NARG) ;
         IS = IS + 1 ;
       ENDO ;
       KVEC = KVEC * CS ;         /*  SUM ON S   */

       HP = 0 ;  HPN = 0 ;      /*  TO SAVE SPACE  */
     ELSE ;
       KVEC = NARG ;
     ENDIF ;

       NARG = 0 ;      /*  TO SAVE SPACE  */
     FHAT = FHAT + KVEC ;
   ELSEIF IKER == 2 ;
     IS = VIS[IOBS] ;
     IE = VIE[IOBS] ;
     IF IS <= IE ;    /*  IF DATA POINT IS WITHIN H OF INTERVAL  */
       IF KPAR == 0 ;      /*  UNIFORM KERNEL  */
         KVEC = ONES(IE-IS+1,1) ;
         KVEC = KVEC * (1 / 2) ;           /*  CONSTANT FROM MARRON-NOLAN  */
       ELSE ;
         ARG = (XGRID[IS:IE,1] - DATA[IOBS]) / H ;
         KVEC = 1 - ARG .* ARG ;
         IF KPAR == 1 ;     /*  EPANECHNIKOV KERNEL  */
           KVEC = KVEC * (3 / 4) ;         /*  CONSTANT FROM MARRON-NOLAN  */
         ELSEIF KPAR == 2 ;    /*  BIWEIGHT KERNEL  */
           KVEC = KVEC .* KVEC ;
           KVEC = KVEC .* (15 / 16) ;      /*  CONSTANT FROM MARRON-NOLAN  */
         ELSEIF KPAR == 3 ;    /*  TRIWEIGHT KERNEL  */
           KVEC = KVEC .* KVEC .* KVEC ;
           KVEC = KVEC .* (35 / 32) ;      /*  CONSTANT FROM MARRON-NOLAN  */
         ELSE ;               /*  USE MARRON-NOLAN GENERAL FORMULA  */
           KVEC = KVEC^KPAR ;
           KVEC = KVEC .* (GAMMA(2*KPAR+2) * GAMMA(KPAR+1)^(-2)) ;
           KVEC = KVEC .* 2^(-2*KPAR-1) ;
         ENDIF ;
         ARG = 0 ;           /*  TO SAVE SPACE  */
       ENDIF ;

       FHAT[IS:IE,1] = FHAT[IS:IE,1] + KVEC ;
     ENDIF ;
   ENDIF ;

   IOBS = IOBS + 1 ;
 ENDO ; ? ;

 FHAT = FHAT / (NOBS * H) ;


 RETP(FHAT) ;
ENDP ;
/* ============================ END PROC GPKED1 ======================== */
