/* =========================== START PROC GPKED2 ======================== */
PROC GPKED2(DATA,LEFT,RIGHT,NXGRID,H,IKER,KPAR) ;
   /*  DIRECT MATRIX CALCULATION OF A KERNEL ESTIMATE OF A DENSITY  */
   /*  ALGORITHM HERE IS A VERY SLOW DOUBLE LOOP  */
   /*     caution: SHOULD USED BINNED VERSION BNKED1.G FOR SPEED  */
   /*              OR AT LEAST USE GPKED1.G, WHICH GIVES SAME ANSWER  */
   /*  ON AN EQUALLY SPACED GRID OF NXGRID POINTS,   */
   /*      EQUALLY SPACED FROM LEFT TO RIGHT  */
   /*  H IS THE BANDWIDTH, MUST BE A SCALAR    */
   /*  IKER = 1  -  GAUSSIAN HIGHER ORDER FAMILY    */
   /*            KPAR = 2  -  STANDARD NORMAL   */
   /*            KPAR = 4  -  GRAM CHARLIER, ORDER 4   */
   /*            KPAR = 6  -  GRAM CHARLIER, ORDER 6   */
   /*  IKER = 2  -  BETA, SUPPORTED [-1,1], WITH  */
   /*            KPAR = 0  -  UNIFORM   */
   /*            KPAR = 1  -  EPANECHNIKOV   */
   /*            KPAR = 2  -  BIWEIGHT   */
   /*            KPAR = 3  -  TRIWEIGHT   */
   /*  OUTPUT IS A MATRIX,       */
   /*  FIRST COLUMN IS HEIGHTS OF THE ESTIMATE, AT BIN CENTERS  */
   /*  SECOND COLUMN IS THE KERNEL FUNCTION USED   */
   /*  CAUTION, KERNEL ONLY GIVES SHAPE AND WILL NEED RESCALING  */

 LOCAL NOBS,XGRID,IOBS,IXG,IVEC,FHAT,ARG,R,CS,NARG,HP,HPN,IS,KVEC,FLAG,IE ;

 NOBS = ROWS(DATA) ;

 XGRID = SEQA(LEFT,(RIGHT - LEFT) / (NXGRID - 1),NXGRID) ;
 IVEC = SEQA(1,1,NXGRID) ;

 IOBS = 1 ;
 FHAT = ZEROS(NXGRID,1) ;
 DO WHILE IOBS <= NOBS ;
   "." ;;

   IXG = 1 ;
   DO WHILE IXG <= NXGRID ;

     ARG = (XGRID[IXG] - DATA[IOBS]) / H ;

     IF IKER == 1 ;
       R = KPAR / 2 ;                           /*  CONVENIENT FOR HERMITES  */
       CS = SEQM(1,-.5,R) ./ SEQA(0,1,R)! ;     /*  COEFFS FOR HERMITES  */

       NARG = PDFN(ARG) ;

       IF KPAR > 2 ;
         HP = ONES(ROWS(ARG),COLS(ARG)) ;       /*  0TH HERMITE POLY  */
         HPN = ARG ;                         /*  1ST HERMITE POLY  */
         KVEC = HP .* NARG ;
         IS = 1 ;
         DO WHILE IS <= (R - 1) ;
           HP = ARG .* HPN - (2*IS - 1) * HP ;   /* (2*IS)-TH HERMITE POLY  */
           HPN = ARG .* HP - (2*IS) * HPN ;   /*  (2*IS+1)-TH HERMITE POLY  */
           KVEC = KVEC~(HP .* NARG) ;
           IS = IS + 1 ;
         ENDO ;
         KVEC = KVEC * CS ;         /*  SUM ON S   */

       ELSE ;
         KVEC = NARG ;
       ENDIF ;

     ELSEIF IKER == 2 ;
       KVEC = (ABS(ARG) .< 1) ;

       IF KPAR == 0 ;      /*  UNIFORM KERNEL  */
         KVEC = KVEC * (1 / 2) ;           /*  CONSTANT FROM MARRON-NOLAN  */
       ELSE ;
         KVEC = KVEC .* (1 - ARG .* ARG) ;
         IF KPAR == 1 ;     /*  EPANECHNIKOV KERNEL  */
           KVEC = KVEC * (3 / 4) ;         /*  CONSTANT FROM MARRON-NOLAN  */
         ELSEIF KPAR == 2 ;    /*  BIWEIGHT KERNEL  */
           KVEC = KVEC .* KVEC ;
           KVEC = KVEC .* (15 / 16) ;      /*  CONSTANT FROM MARRON-NOLAN  */
         ELSEIF KPAR == 3 ;    /*  TRIWEIGHT KERNEL  */
           KVEC = KVEC .* KVEC .* KVEC ;
           KVEC = KVEC .* (35 / 32) ;      /*  CONSTANT FROM MARRON-NOLAN  */
         ELSE ;               /*  USE MARRON-NOLAN GENERAL FORMULA  */
           KVEC = KVEC^KPAR ;
           KVEC = KVEC .* (GAMMA(2*KPAR+2) * GAMMA(KPAR+1)^(-2)) ;
           KVEC = KVEC .* 2^(-2*KPAR-1) ;
         ENDIF ;
         ARG = 0 ;           /*  TO SAVE SPACE  */
       ENDIF ;

     ENDIF ;

     FHAT[IXG] = FHAT[IXG] + KVEC / (NOBS * H) ;

     IXG = IXG + 1 ;
   ENDO ;

   IOBS = IOBS + 1 ;
 ENDO ; ? ;


 RETP(FHAT) ;
ENDP ;
/* ============================ END PROC GPKED2 ======================== */
