/* =========================== START PROC GPKED3 ======================== */
PROC GPKED3(XGRID,DATA,H,KPAR) ;
   /*  GASSER'S DIRECT CALCULATION OF A KERNEL ESTIMATE OF A DENSITY  */
   /*  XGRID IS THE VECTOR OF SITES TO EVALUATE THE ESTIMATE     */
   /*          ASSUMED SORTED                            */
   /*  DATA IS THE VECTOR OF DATA                           */
   /*          ASSUMED SORTED                            */
   /*  H IS THE BANDWIDTH, MUST BE A SCALAR    */
   /*  KERNEL SHAPE IS THE BETA,   SUPPORTED [-1,1],    WITH  */
   /*            KPAR = 0  -  UNIFORM   */
   /*            KPAR = 1  -  EPANECHNIKOV   */
   /*            KPAR = 2  -  BIWEIGHT   */
   /*            KPAR = 3  -  TRIWEIGHT   */
   /*  OUTPUT IS A THE VECTOR OF THE KERNEL DENSITY ESTIMATE       */

 LOCAL NOBS,NXGRID,DOH,XOH,XOH2,VIS,VIE,ARG,S0,S1,S2,S3,S4,S5,S6,FHAT ;


 NOBS = ROWS(DATA) ;                 /*  NUMBER OF DATA POINTS  */
 NXGRID = ROWS(XGRID) ;               /*  NUMBER OF GRIDPOINTS  */

     /*  CONSTRUCT VECTOR OF STARTING INDICES  */
 VIE = COUNTS(DATA,XGRID + H) ;
 VIE = CUMSUMC(VIE) ;
     /*  CONSTRUCT VECTOR OF ENDING INDICES  */
 VIS = COUNTS(-DATA,REV(H - XGRID)) ;
 VIS = VIS[2:NXGRID]|(NOBS-SUMC(VIS)) ;
 VIS = REV(VIS) ;
 VIS = CUMSUMC(VIS) ;

     /*  ADD 0 TO BEGINNING TO HANDLE 0 INDICES  */
 VIS = VIS + 1 ;
 VIE = VIE + 1 ;

 S0 = SEQA(1,1,NOBS) ;
 S0 = 0|S0 ;
 S0 = S0[VIE] - S0[VIS] ;
 IF KPAR >= 1 ;
   DOH = DATA ./ H ;
   XOH = XGRID ./ H ;
   XOH2 = XOH .* XOH ;
   S1 = CUMSUMC(DOH) ;
   S1 = 0|S1 ;
   S1 = S1[VIE] - S1[VIS] ;
   ARG = DOH .* DOH ;
   S2 = CUMSUMC(ARG) ;
   S2 = 0|S2 ;
   S2 = S2[VIE] - S2[VIS] ;
   IF KPAR >= 2 ;
     ARG = ARG .* DOH ;
     S3 = CUMSUMC(ARG) ;
     S3 = 0|S3 ;
     S3 = S3[VIE] - S3[VIS] ;
     ARG = ARG .* DOH ;
     S4 = CUMSUMC(ARG) ;
     S4 = 0|S4 ;
     S4 = S4[VIE] - S4[VIS] ;
     IF KPAR >= 3 ;
       ARG = ARG .* DOH ;
       S5 = CUMSUMC(ARG) ;
       S5 = 0|S5 ;
       S5 = S5[VIE] - S5[VIS] ;
       ARG = ARG .* DOH ;
       S6 = CUMSUMC(ARG) ;
       S6 = 0|S6 ;
       S6 = S6[VIE] - S6[VIS] ;
                    /*   DO TRIWEIGHT KERNEL  */
       FHAT = (1 - XOH2)^3 .* S0 ;
       FHAT = FHAT + 6 * XOH .* (1 - XOH2)^2 .* S1 ;
       FHAT = FHAT - 3 * (1 - 5 * XOH2) .* (1 - XOH2) .* S2 ;
       FHAT = FHAT - 4 * XOH .* (3 - 5 * XOH2) .* S3 ;
       FHAT = FHAT + 3 * (1 - 5 * XOH2) .* S4 ;
       FHAT = FHAT + 6 * XOH .* S5 ;
       FHAT = FHAT - S6 ;
       FHAT = 35 * FHAT ./ (32 * H * NOBS) ;
     ELSE ;         /*   DO BIWEIGHT KERNEL  */
       FHAT = (1 - XOH2)^2 .* S0 ;
       FHAT = FHAT + 4 * XOH .* (1 - XOH2) .* S1 ;
       FHAT = FHAT - 2 * (1 - 3 * XOH2) .* S2 ;
       FHAT = FHAT - 4 * XOH .* S3 ;
       FHAT = FHAT + S4 ;
       FHAT = 15 * FHAT ./ (16 * H * NOBS) ;
     ENDIF ;
   ELSE ;          /*    DO EPANECHINKOV KERNEL   */
     FHAT = (1 - XOH2) .* S0 ;
     FHAT = FHAT + 2 * XOH .* S1 ;
     FHAT = FHAT - S2 ;
     FHAT = 3 * FHAT ./ (4 * H * NOBS) ;
   ENDIF ;
 ELSE ;            /*    DO UNIFORM KERNEL   */
   FHAT = S0 ./ (2 * H * NOBS) ;
 ENDIF ;

 RETP(FHAT) ;
ENDP ;
/* ============================ END PROC GPKED3 ======================== */
