/* =========================== START PROC GPLKD1 ======================== */
PROC GPLKD1(DATA,XGRID,VH,HTYPE,IKER,KPAR) ;
   /*  LOCAL KERNEL DENSITY ESTIMATE   */
   /*  A DIRECT IMPLEMENTATION, HENCE RELATIVELY SLOW,   */
   /*  AND COULD HAVE WORKSPACE PROBLEMS FOR LARGE DATA SETS  */
   /*  DATA IS A COLUMN VECTOR OF POINTS FROM DESIRED DENSITY  */
   /*  XGRID IS A COLUMN VECTOR OF PLACES TO EVALUTATE   */
   /*  VH IS A COLUMN VECTOR OF BANDWIDTHS     */
   /*  HTYPE = 1   -   BANDWIDTH DEPENDING ON x   */
   /*                LENGTH OF VH SAME AS XGRID    */
   /*  HTYPE = 2   -   BANDWIDTH DEPENDING ON X_i   */
   /*                LENGTH OF VH SAME AS DATA    */
   /*  IKER = 1  -  STANDARD NORMAL   */
   /*            KPAR HAS NO EFFECT   */
   /*  IKER = 2  -  BETA, SUPPORTED [-1,1], WITH  */
   /*            KPAR = 0  -  UNIFORM   */
   /*            KPAR = 1  -  EPANECHNIKOV   */
   /*            KPAR = 2  -  BIWEIGHT   */
   /*            KPAR = 3  -  TRIWEIGHT   */
   /*  OUTPUT IS A VECTOR OF HEIGHTS OF THE ESTIMATE, AT XGRID  */

 LOCAL NOBS,ARG,FHAT,CONST ;

 NOBS = ROWS(DATA) ;

 ARG = DATA - XGRID' ;

 IF HTYPE == 1 ;
   ARG = ARG ./ VH' ;
 ELSEIF HTYPE == 2 ;
   ARG = ARG ./ VH ;
 ENDIF ;


 IF IKER == 1 ;        /*  WORK WITH GAUSSIAN FAMILY  */
   FHAT = PDFN(ARG) ;
   CONST = 1 ;
 ELSEIF IKER == 2 ;    /*  WORK WITH BETA FAMILY  */

   IF KPAR == 0 ;      /*  UNIFORM KERNEL  */
     FHAT = (ABS(ARG) .<= 1) ;
     CONST = (1 / 2) ;              /*  CONSTANT FROM MARRON-NOLAN  */
   ELSE ;
     FHAT = 1 - ARG .* ARG ;
     ARG = 0 ;   /*  TO SAVE SPACE  */
     FHAT = FHAT .* (FHAT .> 0) ;
     IF KPAR == 1 ;     /*  EPANECHNIKOV KERNEL  */
       CONST = (3 / 4) ;            /*  CONSTANT FROM MARRON-NOLAN  */
     ELSEIF KPAR == 2 ;    /*  BIWEIGHT KERNEL  */
       FHAT = FHAT .* FHAT ;
       CONST = (15 / 16) ;         /*  CONSTANT FROM MARRON-NOLAN  */
     ELSEIF KPAR == 3 ;    /*  TRIWEIGHT KERNEL  */
       FHAT = FHAT .* FHAT .* FHAT ;
       CONST = (35 / 32) ;         /*  CONSTANT FROM MARRON-NOLAN  */
     ELSE ;               /*  USE MARRON-NOLAN GENERAL FORMULA  */
       FHAT = FHAT^KPAR ;
       CONST = (GAMMA(2*KPAR+2) * GAMMA(KPAR+1)^(-2) * 2^(-2*KPAR-1)) ;
     ENDIF ;
   ENDIF ;

 ENDIF ;



 IF HTYPE == 1 ;
   FHAT = FHAT ./ VH' ;
 ELSEIF HTYPE == 2 ;
   FHAT = FHAT ./ VH ;
 ENDIF ;

 FHAT = SUMC(FHAT) ;
 FHAT = FHAT * CONST ;
 FHAT = FHAT / NOBS ;

 RETP(FHAT) ;
ENDP ;
/* ============================ END PROC GPLKD1 ======================== */
